<?php

namespace ClientBase;

class APITest
{
    private $url = null;
    private $login = null;
    private $auth_key = null;
    private $access_id = '';
    private $count_error = 0;
    private $time_start = 0;
    private $time_points = array();
    public $debug = false;

    public function __construct()
    {
        global $result_table_info, $fields, $fields_filter;
        session_start();
        if (isset($_SESSION['access_id'])) {
            $this->access_id = $_SESSION['access_id'];
        }
        if (isset($_SESSION['url'])) {
            $this->url = $_SESSION['url'];
        }
        if (isset($_SESSION['login'])) {
            $this->login = $_SESSION['login'];
        }
        if (isset($_SESSION['auth_key'])) {
            $this->auth_key = $_SESSION['auth_key'];
        }
        if (isset($_SESSION['result_table_info'])) {
            $result_table_info = $_SESSION['result_table_info'];
        }
        if (isset($_SESSION['fields'])) {
            $fields = $_SESSION['fields'];
        }
        if (isset($_SESSION['fields_filter'])) {
            $fields_filter = $_SESSION['fields_filter'];
        }
    }

    public function getParamAuth($url, $login, $auth_key)
    {
        $this->url = $url;
        $_SESSION['url'] = $this->url;
        $this->login = $login;
        $_SESSION['login'] = $this->login;
        $this->auth_key = $auth_key;
        $_SESSION['auth_key'] = $this->auth_key;

        $this->access_id = $this->auth();
        if ($this->access_id) {
            $_SESSION['access_id'] = $this->access_id;
        }
    }

    private function auth()
    {
        // Запрос соли
        if ($this->login != null) {
            $result_auth_request = $this->sendCommandAuth('api/auth/request/', array(
                "v" => "1.0",
                "login" => $this->login
            ));

            $this->set_time_point('api/auth/request/');

            // Авторизация
            if (isset($result_auth_request["salt"])) {
                $result_auth_auth = $this->sendCommandAuth('api/auth/auth/', array(
                    "v" => "1.0",
                    "login" => $this->login,
                    "hash" => md5($result_auth_request["salt"] . $this->auth_key)
                ));

                $this->set_time_point('api/auth/auth/');
            } else {
                return false;
            }

            return $result_auth_auth["access_id"];
        } else {
            return false;
        }
    }

    // Отправка команды на сервер
    private function send_command_server($server_url, $server_command)
    {
        // Пеобразуем в json
        $data_string = json_encode($server_command);

        if ($server_url) {
            // установка URL и других необходимых параметров
            $ch = curl_init($server_url);
            //curl_setopt($ch, CURLOPT_PROXY, '192.168.1.1:3000');
            curl_setopt($ch, CURLOPT_CUSTOMREQUEST, "POST");
            curl_setopt($ch, CURLOPT_POSTFIELDS, $data_string);
            curl_setopt($ch, CURLOPT_HEADER, false);
            curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
            curl_setopt($ch, CURLOPT_HTTPHEADER, array(
                    'Content-Type: application/json',
                    'Content-Length: ' . strlen($data_string)
                )
            );

            // загрузка страницы и выдача её браузеру
            $json = curl_exec($ch);
            if ($json === false) {
                return array('code' => -1, 'message' => 'error curl: ' . curl_error($ch));
            }

            // Переобразуем в массив
            $result = json_decode($json, true);

            // завершение сеанса и освобождение ресурсов
            curl_close($ch);

            if (count($result)) {
                return $result;
            } else {
                switch (json_last_error()) {
                    case JSON_ERROR_NONE:
                        $error_msg = 'Ошибок нет';
                        break;
                    case JSON_ERROR_DEPTH:
                        $error_msg = 'Достигнута максимальная глубина стека';
                        break;
                    case JSON_ERROR_STATE_MISMATCH:
                        $error_msg = 'Некорректные разряды или не совпадение режимов';
                        break;
                    case JSON_ERROR_CTRL_CHAR:
                        $error_msg = 'Некорректный управляющий символ';
                        break;
                    case JSON_ERROR_SYNTAX:
                        $error_msg = 'Синтаксическая ошибка, не корректный JSON';
                        break;
                    case JSON_ERROR_UTF8:
                        $error_msg = 'Некорректные символы UTF-8, возможно неверная кодировка';
                        break;
                    default:
                        $error_msg = 'Неизвестная ошибка';
                        break;
                }
                return "$error_msg: '$json'";
            }
        } else {
            return array('code' => -1, 'message' => 'url error');
        }
    }

    public function echo_debug($array)
    {
        echo "<pre>";
        print_r($array);
        echo "</pre>";
    }

    public function set_time_start($time)
    {
        $this->time_start = $time;
        $this->set_time_point('Start', $time);
    }

    public function set_time_point($name, $time = 0)
    {
        if ($time == 0) {
            $time = microtime(true);
        }
        $this->time_points[count($this->time_points) . '. ' . $name] = $this->diff_time($time);
    }

    public function diff_time($time)
    {
        return $time - $this->time_start;
    }

    public function get_time_points()
    {
        return $this->time_points;
    }

    public function print_time_points()
    {
        $time_old = 0;
        foreach ($this->get_time_points() as $name => $time) {
            print_r("Время выполнения " . round(($time), 2) . " сек (" . (int)(($time) * 1000) . " ms)" .
                " ($name - " . ($time_old ? ((int)(($time) * 1000) - (int)(($time_old) * 1000)) : 0) . " ms)<br>" . PHP_EOL);
            $time_old = $time;
        }
        print_r("Общее время выполнения: " . round(($time_old), 2) . " сек (" . (int)(($time_old) * 1000) . " ms)");
    }

    public function handleRequest()
    {
        $request_url = str_replace(str_replace("index.php", "", $_SERVER['SCRIPT_NAME']), "", $_SERVER['REQUEST_URI']);
        $request_url_array = array_diff(explode('/', $request_url), array(''));
        if (count($request_url_array) == 2) {
            $table_id = (int)join('', array_slice($request_url_array, -2, 1));
            $line_id = (int)ucfirst(join('', array_slice($request_url_array, -1)));
        } elseif (count($request_url_array) == 1) {
            $table_id = (int)join('', array_slice($request_url_array, -2, 1));
            $line_id = 0;
        } else {
            $table_id = 0;
            $line_id = 0;
        }
        return array($table_id, $line_id);
    }

    public function sendCommandAuth($url, $command)
    {
        // Отправка команды на сервер
        if (substr($this->url, -1) != '/') {
            $this->url = $this->url . '/';
        }
        $result = $this->send_command_server($this->url . $url, $command);
        if ($this->debug) {
            $this->echo_debug($result);
        }
        return $result;
    }

    public function sendCommand($url, $command)
    {
        // Отправка команды на сервер
        $command["access_id"] = $this->access_id;
        if ($this->debug) {
            print_r('$url: <br>' . PHP_EOL);
            $this->echo_debug($url);
            print_r('$command: <br>' . PHP_EOL);
            $this->echo_debug($command);
        }
        $result = $this->send_command_server($this->url . $url, $command);
        if (($result['code'] != 0) && ($this->count_error < 3)) {
            $this->count_error++;
            $this->access_id = $this->auth();
            if ($this->access_id) {
                $_SESSION['access_id'] = $this->access_id;
            }
            $result = $this->sendCommand($url, $command);
        }
        if ($this->debug) {
            print_r('$result: <br>' . PHP_EOL);
            $this->echo_debug($result);
            print_r('<hr>');
        }

        return $result;
    }

    public function makePager($page, $lop, $cnt_rec, $page_status, $max_pages_count = 7)
    {
        $all_pages = array();
        // Число страниц
        $cnt_pages = $lop ? ceil($cnt_rec / $lop) : 1;
        // Массив страниц для вывода
        if ($cnt_pages > 1) {
            if ($cnt_pages < $max_pages_count) { // меньше 15 страниц выводим просто так
                for ($i = 0; $i < $cnt_pages; $i++) {
                    $all_pages[] = $i + 1;
                }
            } else { // больше 15 страниц группируем
                $mdl = intval($max_pages_count / 2) + 1;
                $st_i = $page - $mdl;
                if ($st_i < 0) {
                    $end_plus = -$st_i;
                } else {
                    $end_plus = 0;
                }
                $end_i = $page + intval($max_pages_count / 2) + $end_plus;
                if ($end_i > $cnt_pages) {
                    $st_i = $st_i - ($end_i - $cnt_pages);
                }
                // ограничители
                if ($st_i < 0) {
                    $st_i = 0;
                }
                if ($end_i > $cnt_pages) {
                    $end_i = $cnt_pages;
                }
                if ($st_i > 0) {
                    $all_pages[] = 1;
                    if ($st_i > 1) {
                        $all_pages[] = "...";
                    }
                }
                for ($i = $st_i; $i < $end_i; $i++) {
                    $all_pages[] = $i + 1;
                }
                if ($end_i < $cnt_pages) {
                    if ($end_i < ($cnt_pages - 1)) {
                        $all_pages[] = "...";
                    }
                    $all_pages[] = $cnt_pages;
                }
            }
        }
        foreach ($all_pages as $one_page) {
            if ($one_page == $page) {
                echo " <span>$one_page</span>";
            } elseif ($one_page == "...") {
                echo $one_page;
            } else {
                echo " <a href='?page=$one_page$page_status'>$one_page</a>";
            }
        }
        return $all_pages;
    }

    public function getTableInfo($table_id)
    {
        $return = $this->sendCommand('api/table/info/', array(
            "id" => $table_id
        ));
        $this->set_time_point('api/table/info/');
        return $return;
    }

    public function infoFields($result_table_info)
    {
        $fields = array();
        if ($result_table_info['code'] == 0) {
            if (isset($result_table_info['fields']['row'])) {
                foreach ($result_table_info['fields']['row'] as $line) {
                    if ($line['view']) {
                        $fields['line'][$line['name']] = $line;
                        $fields['row'][$line['db_name_field']] = $line;
                        $fields['ids'][$line['id']] = $line;
                    }
                }
            }
        }
        return $fields;
    }

    public function filterFields($infoFields)
    {
        $fields_filter = array();
        if (isset($infoFields['row'])) {
            foreach ($infoFields['row'] as $line) {
                if ($line['view']) {
                    $fields_filter[] = $line['db_name_field'];
                }
            }
        }
        return $fields_filter;
    }

    public function getDataReadOne($table_id, $line_id, $fields_filter, $cals = false)
    {
        return $this->sendCommand('api/data/read/', array(
            "access_id" => '',
            "table_id" => $table_id,
            "cals" => $cals,
            "fields" => array("row" => $fields_filter),
            "filter" => array("row" => array("id" => array("term" => "=", "value" => $line_id, "union" => "AND"))),
            "sort" => array("row" => array("id" => "ASC")),
            "start" => 0,
            "limit" => 1
        ));
    }

    public function getLinkValue($table_id, $line_id, $field_id, $value) {
        global $result_data_read, $result_table_info, $fields, $fields_filter;
        if ($value != 0) {
            $param_value = explode("|", $fields[$table_id]['line'][$field_id]['value']);
            list($table_tmp, $field_tmp) = $param_value;
            $fields[$table_id]['line'][$field_id]['link_table_id'] = (int)$table_tmp;
            $fields[$table_id]['line'][$field_id]['link_field_id'] = (int)$field_tmp;
            if (!isset($result_table_info[$fields[$table_id]['line'][$field_id]['link_table_id']])) {
                if (!isset($result_table_info[$fields[$table_id]['line'][$field_id]['link_table_id']])) {
                    $result_table_info[$fields[$table_id]['line'][$field_id]['link_table_id']] = $this->getTableInfo($fields[$table_id]['line'][$field_id]['link_table_id']);
                }
                if (!isset($fields[$fields[$table_id]['line'][$field_id]['link_table_id']])) {
                    $fields[$fields[$table_id]['line'][$field_id]['link_table_id']] = $this->infoFields($result_table_info[$fields[$table_id]['line'][$field_id]['link_table_id']]);
                }
                if (!isset($fields_filter[$fields[$table_id]['line'][$field_id]['link_table_id']])) {
                    $fields_filter[$fields[$table_id]['line'][$field_id]['link_table_id']] = $this->filterFields($fields[$fields[$table_id]['line'][$field_id]['link_table_id']]);
                }
                $result_data_read[$fields[$table_id]['line'][$field_id]['link_table_id']] = $this->getDataReadOne($fields[$table_id]['line'][$field_id]['link_table_id'],
                    $value, $fields_filter[$fields[$table_id]['line'][$field_id]['link_table_id']]);
            }
            if (
                isset($result_data_read[$fields[$table_id]['line'][$field_id]['link_table_id']]['code']) &&
                ($result_data_read[$fields[$table_id]['line'][$field_id]['link_table_id']]['code'] >= 0)
            ) {
                $row_tmp = $result_data_read[$fields[$table_id]['line'][$field_id]['link_table_id']]['data'][$value]['line'];
                $fields_tmp = $fields[$fields[$table_id]['line'][$field_id]['link_table_id']];
                $db_name_field_tmp = $fields_tmp['ids'][$fields[$table_id]['line'][$field_id]['link_field_id']]['name'];
                $result_data_read[$table_id]['data'][$line_id]['line'][$field_id] = "<a href='/api_test/$table_tmp/$value/'>" . $row_tmp[$db_name_field_tmp] . "</a>";
            } else {
                $result_data_read[$table_id]['data'][$line_id]['line'][$field_id] = '<em>Нет доступа</em>';
            }
        } else {
            $result_data_read[$table_id]['data'][$line_id]['line'][$field_id] = '';
        }
        if (isset($result_table_info)) {
            $_SESSION['result_table_info'] = $result_table_info;
        }
        if (isset($fields)) {
            $_SESSION['fields'] = $fields;
        }
        if (isset($fields_filter)) {
            $_SESSION['fields_filter'] = $fields_filter;
        }

        return $result_data_read[$table_id]['data'][$line_id]['line'][$field_id];
    }
}