<?php
$start_time = microtime(true);

header('Content-Type: text/html; charset=utf-8');

require_once(__DIR__ . '/class/APITest.php');
$config = require_once(__DIR__ . '/config.php');
$types_fields = require_once(__DIR__ . '/types_fields.php');
$api = new \ClientBase\APITest($config);
$api->set_time_start($start_time);

$lang = strtolower(substr($_SERVER["HTTP_ACCEPT_LANGUAGE"], 0, 2));
$lang = ($lang == 'ru') ? 'ru' : 'en';
if (file_exists(__DIR__ . '/lang/' . $lang . '.php')) {
    $lang = require_once(__DIR__ . '/lang/' . $lang . '.php');
}

$title = 'APITest';
list ($table_id, $line_id) = $api->handleRequest();

if (isset($_SESSION['result_table_info'])) {
    $result_table_info = $_SESSION['result_table_info'];
}
if (isset($_SESSION['fields'])) {
    $fields = $_SESSION['fields'];
}
if (isset($_SESSION['fields_filter'])) {
    $fields_filter = $_SESSION['fields_filter'];
}

if (isset($_REQUEST['logout'])) {
    unset($_SESSION['access_id']);
    header("Location: " . $_SERVER['HTTP_X_FORWARDED_PROTO'] . "://". $_SERVER['HTTP_HOST'] . $config['url_dir']);
    exit;
} elseif ($line_id != 0) {
    require_once "controllers/line.php";
} elseif ($table_id != 0) {
    require_once "controllers/table.php";
} else {
    require_once "controllers/index.php";
}