<?php
global $api, $table_id, $config;

$name = 'Таблица ' . $table_id;
$title =  $name . ' - ' . $title;
$bread_crumbs = '<a href="' . $config['url_dir'] . '">Список таблиц</a> > ' . $name;

$cur_page = (empty($_GET['page']) ? 1 : intval($_GET['page']));
$sort_by = (empty($_GET['sort_by']) ? 'ID' : $_GET['sort_by']);
$sort_type = (empty($_GET['sort_type']) ? 'up' : $_GET['sort_type']);
if ($sort_type == 'down') {
    $sql_sort_type = 'DESC';
} else {
    $sql_sort_type = 'ASC';
}
$page_a = "?page=$cur_page";

$pages_count = 10;

$limit = $pages_count;
$start = ($cur_page == 1) ? 0 : $limit * ($cur_page - 1);

if (isset($_GET['archive'])) {
    $status = 1;
    $page_status = '&archive';
} elseif (isset($_GET['deleted'])) {
    $status = 2;
    $page_status = '&deleted';
} else {
    $status = 0;
    $page_status = '';
}

$api->set_time_point('Table');

$result_table_info = $api->sendCommand('api/table/info/', array(
    "id" => $table_id
));
if (isset($result_table_info['time'])) {
    if (count($result_table_info['time'])) {
        foreach ($result_table_info['time'] as $key => $time) {
            $api->set_time_point('api/table/info/ - ' . $key, $time);
        }
    }
}

$fields = array();
if ($result_table_info['code'] == 0) {
    if (isset($result_table_info['fields']['line'])) {
        foreach ($result_table_info['fields']['line'] as $line) {
            if ($line['view_tb']) {
                $fields[] = $line['name'];
            }
        }
    }
}

$api->set_time_point('api/table/info/');

$result_data_read = $api->sendCommand('api/data/read/', array(
    "access_id" => '',
    "table_id" => $table_id,
    "cals" => true,
    "fields" => array("line" => $fields),
    "filter" => array("line" => array("Статус записи" => array("term" => "=", "value" => $status, "union" => "AND"))),
    "sort" => array("line" => array("$sort_by" => $sql_sort_type)),
    "start" => $start,
    "limit" => $limit
));

$api->set_time_point('api/data/read/');