{*
 Шаблон вычисления "Дата: Изменить дату"
*}

if (!function_exists('diffDays')) {
    function diffDays($date1, $date2, $day_off, $holiday, $table, $field, $filterId) {
        // Если не учитывать рабочие дни и праздники, возвращаем новую дату
        if ($day_off == 0 && $holiday == 0) return $date2;
        // Определяем оперант для вычисления направления (0 - вперёд, 1 - назад)
        $operant = 0;
        if ($date1 > $date2) $operant = 1;
        //Добовляем фильтр
        $filter = sql_select_array(FILTERS_TABLE, 'id = ', get_filter_id($filterId));
        // Преобразуем исходную дату в формат timestamp
        $current_date = strtotime($date1);
        // Вычисляем разницу в секундах между датами
        $diff_seconds = abs(strtotime($date2) - strtotime($date1));

        // Вычисляем количество полных дней и остаток секунд
        $full_days = floor($diff_seconds / (60 * 60 * 24));
        $remaining_seconds = $diff_seconds % (60 * 60 * 24);

        // Обработка полных дней
        $added_days = 0;
        while ($added_days < $full_days) {
            $current_date = $operant ? strtotime('-1 day', $current_date) : strtotime('+1 day', $current_date);

            // Проверяем наличие праздничного дня в базе данных
            $result = sql_fetch_assoc(data_select_field($table, '*', 'status=0 AND '.$field.' LIKE "' . date('Y-m-d 00:00:00', $current_date) .'"'. ($filter['value'] ? ' AND (' . filter_tpl_replace($filter['value']) . ')' : '')));

            // Учитываем рабочие дни и праздники при подсчёте добавленных дней
            $is_weekday = date('N', $current_date) <= 5;
            $is_holiday = !empty($result['id']);

            if (($day_off && $holiday && $is_weekday && !$is_holiday) ||
                ($day_off && !$holiday && $is_weekday) ||
                (!$day_off && $holiday && !$is_holiday) ||
                (!$day_off && !$holiday)) {
                $added_days++;
            }
        }

        // Обработка оставшихся секунд
        while ($remaining_seconds > 0) {
            $next_date = $operant ? strtotime('-1 second', $current_date) : strtotime('+1 second', $current_date);

            // Проверяем, что следующий день не выходной или праздничный
            $is_weekday = date('N', $next_date) <= 5;
            $result = sql_fetch_assoc(data_select_field($table, '*', 'status=0 AND '.$field.' LIKE "' . date('Y-m-d 00:00:00', $current_date) .'"'. ($filter['value'] ? ' AND (' . filter_tpl_replace($filter['value']) . ')' : '')));

            if (($day_off && $holiday && $is_weekday && !$is_holiday) ||
                ($day_off && !$holiday && $is_weekday) ||
                (!$day_off && $holiday && !$is_holiday) ||
                (!$day_off && !$holiday)) {
                $current_date = $next_date;
                $remaining_seconds--;
            } else {
                // Пропускаем выходные и праздничные дни
                $current_date = $operant ? strtotime('-1 day', $current_date) : strtotime('+1 day', $current_date);
            }
        }

        // Возвращаем конечную дату в формате 'Y-m-d H:i:s'
        return date('Y-m-d H:i:s', $current_date);
    }
}

{if $listerine == 3}// Выберите способ ввода - текущая дата
$line["{$cur_field}"] = date("Y-m-d H:i:s");
{else}
{if $listerine == 1}// Выберите способ ввода - число
$number = {$number_value|default:0};
{elseif $listerine == 2}// Выберите способ ввода - поле с числом
$number = $line["{$cur_field2}"] ? $line["{$cur_field2}"] : 0;
{/if}
$orig_date = strtotime($line["{$cur_field1}"]);
{if $case_measure == 1}
$new_date = $orig_date {$operand} $number;
{elseif $case_measure == 2}
$new_date = $orig_date {$operand} $number * 60;
{elseif $case_measure == 3}
$new_date = $orig_date {$operand} $number * 3600;
{elseif $case_measure == 4}
$new_date = $orig_date {$operand} $number * 3600 * 24;
{elseif $case_measure == 5}
$new_date = $orig_date {$operand} $number * 3600 * 24 * 7;
{elseif $case_measure == 6}
$new_date = mktime(date("H", $orig_date), date("i", $orig_date), date("s", $orig_date), date("n", $orig_date) {$operand} $number, date("j", $orig_date), date("Y", $orig_date));
{elseif $case_measure == 7}
$new_date = mktime(date("H", $orig_date), date("i", $orig_date), date("s", $orig_date), date("n", $orig_date), date("j", $orig_date), date("Y", $orig_date) {$operand} $number);
{/if}
$line["{$cur_field}"] = diffDays(date('Y-m-d H:i:s', $orig_date), date('Y-m-d H:i:s', $new_date), {$day_off|default:0}, {$holiday|default:0}, {$gen_field.table|default:0}, {$gen_field.field|default:0},{$gen_field.filter|default:0});
{/if}