import LineView from './line-view';
import {ILine} from './line';
import Model from '../model';
import {URL, getUrlVars, renderPage, drawNoAccess} from '../util';
import App from '../app'
import Access from '../access';
import View from '../view';

export default class LineController {
    private lineId: number;
    private model: Model;

    public init(data: {
        lineId: number
    }): void {
        this.lineId = data.lineId;
        this.model = new Model();
        this.model.getData(`${URL}?show_line=${data.lineId}`)
            .then((response: {
                lines: Array<ILine>
            }): void => {
                Access.setAccess(response as any);
                if (Access.show === 1) {
                    const lineView: LineView = new LineView(response.lines);
                    renderPage(lineView);
                } else {
                    const view = new class extends View {
                        protected get template(): string {
                            return drawNoAccess(`Нет доступа на просмотр записи`);
                        }
                    };
                    renderPage(view);
                }
                this.bind();
            })
            .catch((err: Error): void => {
                throw new Error(`Error with render view line, ${err}`);
            });
    }

    private bind = (bind: boolean = true): void => {
        const backBtn: HTMLButtonElement = document.querySelector(`#back-btn`);

        if (backBtn) {
            if (bind) {
                backBtn.addEventListener(`click`, this.onBackClick);
            } else {
                backBtn.removeEventListener(`click`, this.onBackClick);
            }
        }

        const editBtn: HTMLButtonElement = document.querySelector(`#edit-btn`);

        if (editBtn) {
            if (bind) {
                editBtn.addEventListener(`click`, this.onEditCLick);
            } else {
                editBtn.removeEventListener(`click`, this.onEditCLick);
            }
        }

        const deleteBtn: HTMLButtonElement = document.querySelector(`#delete-btn`);

        if (deleteBtn) {
            if (bind) {
                deleteBtn.addEventListener(`click`, this.onDeleteClick);
            } else {
                deleteBtn.removeEventListener(`click`, this.onDeleteClick);
            }
        }
    };

    private onDeleteClick = () => {
        this.bind(false);
        this.model.deleteLine(`${URL}?delete=${this.lineId}`)
            .then(() => {
                App.showTable({
                    pagination: parseInt(getUrlVars()[`pagination`]) || 0,
                    search: getUrlVars()[`search`] || ``
                });
            })
    };

    private onEditCLick = () => {
        this.bind(false);
        App.showEdit({
            id: this.lineId
        });
    };

    private onBackClick = () => {
        this.bind(false);
        App.showTable({
            pagination: parseInt(getUrlVars()[`pagination`]) || 0,
            search: getUrlVars()[`search`] || ``
        })
    };
}