import useAdditionallyTabWazzupExtensionStore from './../../store/useAdditionallyTabWazzupExtensionStore.js';

export const MaximumNumberOfMessages = {
  name: 'maximum-number-of-messages',

  setup(props, {emit}) {
    const additionallyStore = useAdditionallyTabWazzupExtensionStore();

    Vue.onMounted(() => {
      checkHelpButtonsOnCurrentPage();
      bind_help_bt('wazzup');
    });

    return {
      additionallyStore,

      validateMinimumValue(value) {
        if (Number(value) <= 0) {
          additionallyStore.maximum_number_of_messages_per_hour = 60;
        }
      }
    }
  },

  template: /*html*/`
    <div class="additionally-def_chan_for_reminder">
      <div>
        <span>{{ $t('maximum_number_of_messages_per_hour') }}</span>
        <span
          h_id="wazzup_maximum_number_of_messages_per_hour"
          class="help_bt"
        ></span>
        <span>:</span>
      </div>

      <div>
        <input
          type="number"
          :min="1"
          class="form-control"
          v-model="additionallyStore.maximum_number_of_messages_per_hour"
          @blur="validateMinimumValue(additionallyStore.maximum_number_of_messages_per_hour)"
        />
      </div>
    </div>
  `
}
