function createHelpBtn() {
    return {
        view: function(vnode) { return m('span[class=help_bt]', {h_id:vnode.attrs.helpbtn}); },
        oncreate: function() { bind_help_bt('app'); },
        oninit: checkHelpButtonsOnCurrentPage(),
    }
}

let SimpleKeyComponent = {
    view: function(vnode) {
        return m('tr', [
            m('td[width=45%][align=right]', [
                m('span', vnode.attrs.name),
                m('span[class=help_bt]', {
                    oninit: checkHelpButtonsOnCurrentPage(),
                    oncreate: function() { bind_help_bt('app'); },
                    h_id: vnode.attrs.hId
                }), m('span', ':')
            ]),
            m('td', m('input[type=' + (vnode.attrs.key == 'shopId' ? 'text' : 'password') + ']', {
                class: 'form-control',
                value: vnode.attrs.value,
                style: { width: '250px' },
                onchange: function(e) {
                    if (vnode.attrs.key == 'shopId') Storage.shopId['value'] = e.target.value;
                    if (vnode.attrs.key == 'apiKey') Storage.apiKey['value'] = e.target.value;
                    Storage.checkConnection(Storage.shopId['value'], Storage.apiKey['value']);
                },
            })),
        ]);
    }
};

let KeyComponent = {
    view: function() {
        return Storage.loading ? m('div', m('table[width=100%]', [
            m('tr', m('td[colspan=2][align=center]', 'Загрузка данных...'))
        ])) : m('div', m('table[width=100%]', [
            m('tr', [
                m('td[colspan=2][align=center]', {style: {padding: '0 0 10px 0'}}, [
                    m('a', {
                        target: '_blank',
                        href: 'https://yookassa.ru/my/merchant/integration/api-keys'
                    }, m('span', {style: {
                        'font-size': '14px', 'font-family': 'system-ui'
                    }}, 'Личный кабинет Ю.Kassa'))
                ])
            ]),
            m(SimpleKeyComponent, {
                name: 'Идентификатор магазина',
                hId: 'module_yandex_payment_shopId',
                value: Storage.shopId['value'],
                key: 'shopId'
            }),
            m(SimpleKeyComponent, {
                name: 'Ключ API',
                hId: 'module_yandex_payment_apiKey',
                value: Storage.apiKey['value'],
                key: 'apiKey'
            }),
            m('tr', m('td[colspan=2][align=center]', (Storage.shopId['code'] == 1 && Storage.apiKey['code'] == 1 ? m('div', {class: 'span--success'}, [
                m('span', 'Авторизация пройдена успешно.')
            ]) : m('div', {class: 'span--fail'}, [
                m('span', (Storage.shopId['code'] == 3 ? '' : 'Неправильный ключ api или идентификатор магазина.'))
            ]))))
        ]));
    }
};

let HelpComponent = {
    view: function(vnode) {
        return [
            m('span', vnode.attrs.name),
            m('span[class=help_bt]', {
                oninit: checkHelpButtonsOnCurrentPage(),
                oncreate: function() { bind_help_bt('app'); },
                h_id: vnode.attrs.hId
            }), m('span', ':')
        ]
    }
};

let SimpleComponent = {
    view: function(vnode) {
        return m('tr', [
            m('td[width=45%][align=right]', [
                m('a', m('img[src=images/b_drop.png]', {
                    onclick: function() {
                        delete(Storage.set[vnode.attrs.num]);
                        if (vnode.attrs.num == Storage.show) Storage.show = 0;
                    },
                    style: {padding: '0 3px 2px 0'}
                })),
                m('a', {
                    onclick: function() {
                        Storage.show = vnode.attrs.num == Storage.show ? 0 : vnode.attrs.num;
                    }
                }, m('span', vnode.attrs.table))
            ]),
            m('td'),
        ])
    }
};

// Добавление таблицы
let AddTable = {
    view: function(vnode) {
        return m('tr', [
            m('td[width=45%][align=right]', m('a', {
                onclick: function() {
                    Storage.show = 0;
                    Storage.set['new'] = { table: 0 };
                    Storage.show = 'new';
                }
            }, 'Добавить таблицу')),
            m('td'),
        ]);
    }
};

let ListTableComponent = {
    oninit: function() {
        let data = new FormData()
        data.append('csrf', csrf)
        data.append('action', 'getTablesList')
        return m.request({
            url: 'modules/yandex_payment/get-data.php',
            method: 'POST',
            data: data
        })
        .then(function(responce) {
            // console.log(responce);
            if (responce['set'] != undefined) {
                let size = 1;
                for (let i in responce['set']) {
                    Storage.set[size] = responce['set'][i];
                    size++;
                }
            }
        });
    },

    view: function() {
        let arr = new Array();
        for (let i in Storage.set) {
            arr.push(m(SimpleComponent, {
                num: i,
                table: Storage.set[i]['table'] == 0 ? 'Таблица не выбрана' : (Storage.tables[Storage.set[i]['table']]['name_table'] == undefined ? '' : Storage.tables[Storage.set[i]['table']]['name_table'])
            }));
        }
        arr.push(m(AddTable));
        return m('div', { style: "margin-bottom: 10px;" }, m('table[width=100%]', arr));
    }
};

let TableSelect = {
    view: function(vnode) {
        let arr = new Array();
        arr.push(m('option', ''));
        for (let i in Storage.tables) {
            let check = false;
            for (let j in Storage.set) {
                if (Storage.set[Storage.show]['table'] != i && Storage.set[j]['table'] == i) check = true;
            }
            if (check) continue;
            arr.push(m('option', {
                value: Storage.tables[i]['id'],
                selected: Storage.tables[i]['id'] == Storage.set[Storage.show]['table'] ? 'selected' : ''
            }, Storage.tables[i]['name_table']));
        }
        return m('select', {
            class: 'form-control form-control-250',
            onchange: function(e) {
                if (Storage.show == 'new') {
                    let size = Number(Storage.size()) + 1;
                    Storage.set[size] = { table: e.target.value, capture: 1, amountCurrency: 'RUB' };
                    Storage.show = size;
                    delete(Storage.set['new']);
                } else {
                    Storage.set[Storage.show]['table'] = e.target.value;
                }
            },
        }, arr);
    }
};

let Select = {
    view: function(vnode) {
        let arr = new Array();
        arr.push(m('option', ''));
        for (let i in Storage.fields['fields']) {
            if (vnode.attrs.typeField == 'all' || !vnode.attrs.typeField) {}
            else if (vnode.attrs.typeField != Storage.fields['fields'][i]['type_field']) continue;
            arr.push(m('option', {
                selected: vnode.attrs.set == i ? 'selected' : '',
                value: Storage.fields['fields'][i]['id']
            }, Storage.fields['fields'][i]['name_field']));
        }
        return m('select', {
            class: 'form-control form-control-250',
            value: vnode.attrs.value,
            onchange: vnode.attrs.onchange instanceof Function ? vnode.attrs.onchange : function() {}
        }, arr);
    }
};

function getFieldsForThisTable(table) {
    if (table == Storage.fields['tableId']) return;
    let data = new FormData();
    data.append('csrf', csrf);
    data.append('action', 'getTableInfo');
    data.append('tableId', table);
    return m.request({
        url: 'modules/yandex_payment/get-data.php',
        method: 'POST',
        data: data
    })
    .then(function(responce) {
        // console.log(responce);
        Storage.fields = responce;
    })
}

let statusArrayOption = {
    view: function(vnode) {
        let typeValue = vnode.attrs.def.split("\r\n");
        let arr = new Array();
        arr.push(m('option', ''));
        for (let i in typeValue) {
            arr.push(m('option', {
                value: typeValue[i],
                selected: Storage.set[Storage.show][vnode.attrs.name] == undefined ? '' : (
                    Storage.set[Storage.show][vnode.attrs.name] == typeValue[i] ? 'selected' : ''
                )
            }, typeValue[i]));
        }
        return m('select', {
            class: 'form-control form-control-250',
            onchange: function(e) {
                Storage.set[Storage.show][vnode.attrs.name] = e.target.value;
            },
        }, arr);
    }
};

function statusArray() {
    return [
        m('tr', [
            m('td[width=45%][align=right][colspan=2]', 'Новый:'),
            m('td[colspan=3]', m(statusArrayOption, {
                name: 'pending',
                set: Storage.set[Storage.show]['pending'] == undefined ? '' : Storage.set[Storage.show]['pending'],
                def: Storage.set[Storage.show]['status'] == undefined ? '' : (
                    Storage.fields['fields'][Storage.set[Storage.show]['status']] == undefined ? '' : Storage.fields['fields'][Storage.set[Storage.show]['status']]['type_value']
                )
            }))
        ]),
        m('tr', [
            m('td[width=45%][align=right][colspan=2]', 'Ожидает подтверждения:'),
            m('td[colspan=3]', m(statusArrayOption, {
                name: 'waiting_for_capture',
                set: Storage.set[Storage.show]['waiting_for_capture'] == undefined ? '' : Storage.set[Storage.show]['waiting_for_capture'],
                def: Storage.set[Storage.show]['status'] == undefined ? '' : (
                    Storage.fields['fields'][Storage.set[Storage.show]['status']] == undefined ? '' : Storage.fields['fields'][Storage.set[Storage.show]['status']]['type_value']
                )
            }))
        ]),
        m('tr', [
            m('td[width=45%][align=right][colspan=2]', 'Оплачен:'),
            m('td[colspan=3]', m(statusArrayOption, {
                name: 'succeeded',
                set: Storage.set[Storage.show]['succeeded'] == undefined ? '' : Storage.set[Storage.show]['succeeded'],
                def: Storage.set[Storage.show]['status'] == undefined ? '' : (
                    Storage.fields['fields'][Storage.set[Storage.show]['status']] == undefined ? '' : Storage.fields['fields'][Storage.set[Storage.show]['status']]['type_value']
                )
            }))
        ]),
        m('tr', [
            m('td[width=45%][align=right][colspan=2]', {
                style: { 'padding-bottom': '15px' }
            }, 'Отменен:'),
            m('td[colspan=3]', {
                style: { 'padding-bottom': '15px' }
            }, m(statusArrayOption, {
                name: 'canceled',
                set: Storage.set[Storage.show]['canceled'] == undefined ? '' : Storage.set[Storage.show]['canceled'],
                def: Storage.set[Storage.show]['status'] == undefined ? '' : (
                    Storage.fields['fields'][Storage.set[Storage.show]['status']] == undefined ? '' : Storage.fields['fields'][Storage.set[Storage.show]['status']]['type_value']
                )
            }))
        ])
    ];
}

function confirmationUrlArray() {
    let arr = new Array();
    arr.push(m('option', ''));
    for (let i in Storage.fields['filters']) {
        arr.push(m('option', {
            selected: Storage.set[Storage.show]['filter'] == Storage.fields['filters'][i]['id'] ? 'selected' : '',
            value: Storage.fields['filters'][i]['id']
        }, Storage.fields['filters'][i]['name']));
    }
    return [
        m('tr', [
            m('td[width=45%][align=right][colspan=2]', m(HelpComponent, { name: 'Использовать фильтр', hId: 'module_yandex_payment_filter' })),
            m('td[colspan=3]', m('select', {
                class: 'form-control form-control-250',
                value: Storage.set[Storage.show]['filter'] == undefined ? '' : Storage.set[Storage.show]['filter'],
                onchange: function(e) {
                    Storage.set[Storage.show]['filter'] = e.target.value == '' ? 0 : e.target.value;
                },
            }, arr))
        ])
    ];
}

// https://yookassa.ru/developers/payment-acceptance/receipts/54fz/parameters-values#payment-subject
let PaymentSubjectOptions = {
  // Доступно, начиная с ФФД 1.05
  "1.05": [
    {version: '1.05', value: 'commodity', description:	'Товар'},
    {version: '1.05', value: 'excise', description:	'Подакцизный товар'},
    {version: '1.05', value: 'job', description:	'Работа'},
    {version: '1.05', value: 'service', description:	'Услуга'},
    {version: '1.05', value: 'payment', description:	'Платеж'},
    {version: '1.05', value: 'casino', description:	'Платеж казино'},
    {version: '1.05', value: 'gambling_bet', description:	'Ставка в азартной игре'},
    {version: '1.05', value: 'gambling_prize', description:	'Выигрыш азартной игры'},
    {version: '1.05', value: 'lottery', description:	'Лотерейный билет'},
    {version: '1.05', value: 'lottery_prize', description:	'Выигрыш в лотерею'},
    {version: '1.05', value: 'intellectual_activity', description:	'Результаты интеллектуальной деятельности'},
    {version: '1.05', value: 'agent_commission', description:	'Агентское вознаграждение'},
    {version: '1.05', value: 'property_right', description:	'Имущественное право'},
    {version: '1.05', value: 'non_operating_gain', description:	'Внереализационный доход'},
    {version: '1.05', value: 'insurance_premium', description:	'Страховой сбор'},
    {version: '1.05', value: 'sales_tax', description:	'Торговый сбор'},
    {version: '1.05', value: 'resort_fee', description:	'Курортный сбор'},
    {version: '1.05', value: 'composite', description:	'Несколько вариантов'},
    {version: '1.05', value: 'another', description:	'Другое'},
  ],

  // Доступно, начиная с ФФД 1.2
  "1.2": [
    {version: '1.2', value: 'marked', description:	'Товар, подлежащий маркировке средством идентификации, имеющим код маркировки, за исключением подакцизного товара.'},
    {version: '1.2', value: 'non_marked', description:	'Товар, подлежащий маркировке средством идентификации, не имеющим кода маркировки, за исключением подакцизного товара.'},
    {version: '1.2', value: 'marked_excise', description:	'Подакцизный товар, подлежащий маркировке средством идентификации, имеющим код маркировки.'},
    {version: '1.2', value: 'non_marked_excise', description:	'Подакцизный товар, подлежащий маркировке средством идентификации, не имеющим кода маркировки.'},
    {version: '1.2', value: 'fine', description:	'Выплата'},
    {version: '1.2', value: 'tax', description:	'Страховые взносы'},
    {version: '1.2', value: 'lien', description:	'Залог'},
    {version: '1.2', value: 'cost', description:	'Расход'},
    {version: '1.2', value: 'agent_withdrawals', description:	'Выдача денежных средств'},
    {version: '1.2', value: 'pension_insurance_without_payouts', description:	'Взносы на обязательное пенсионное страхование ИП'},
    {version: '1.2', value: 'pension_insurance_with_payouts', description:	'Взносы на обязательное пенсионное страхование'},
    {version: '1.2', value: 'health_insurance_without_payouts', description:	'Взносы на обязательное медицинское страхование ИП'},
    {version: '1.2', value: 'health_insurance_with_payouts', description:	'Взносы на обязательное медицинское страхование'},
    {version: '1.2', value: 'health_insurance', description:	'Взносы на обязательное социальное страхование'},
  ]
};

// https://yookassa.ru/developers/payment-acceptance/receipts/54fz/parameters-values#payment-mode
let PaymentModeOptions = [
  {value: '', description: ''},
  {value: 'full_prepayment',    description:	'Полная предоплата'},
  {value: 'partial_prepayment', description:	'Частичная предоплата'},
  {value: 'advance',            description:	'Аванс'},
  {value: 'full_payment',       description:	'Полный расчет'},
  {value: 'partial_payment',    description:	'Частичный расчет и кредит'},
  {value: 'credit',             description:	'Кредит'},
  {value: 'credit_payment',     description:	'Выплата по кредиту'},
];

let ManyPropertiesComponent = {
    oninit: (vnode) => getFieldsForThisTable(vnode.attrs.table),
    onupdate: (vnode) => getFieldsForThisTable(vnode.attrs.table),

    view: function(vnode) {
        return [
            m('tr', [
                m('td[width=45%][align=right][colspan=2]', m(HelpComponent, { name: 'Сумма платежа', hId: 'module_yandex_payment_summa' })),
                m('td[colspan=3]', m(Select, {
                    set: Storage.set[Storage.show]['amountValue'] == undefined ? '' : Storage.set[Storage.show]['amountValue'],
                    typeField: 1,
                    value: Storage.set[Storage.show]['amountValue'] == undefined ? 0 : Storage.set[Storage.show]['amountValue'],
                    onchange: function(e) {
                        Storage.set[Storage.show]['amountValue'] = e.target.value == '' ? 0 : e.target.value;
                    },
                }))
            ]),
            m('tr', [
                m('td[width=45%][align=right][colspan=2]', m(HelpComponent, { name: 'Валюта по умолчанию', hId: 'module_yandex_payment_currency' })),
                m('td', {
                    style: {display: 'inline-block'}
                }, m('select', {
                    class: 'form-control form-control-250',
                    disabled: Storage.set[Storage.show]['checked'] ? 'disabled' : '',
                    onchange: function(e) {
                        Storage.set[Storage.show]['amountCurrency'] = e.target.value == '' ? 0 : e.target.value;
                    },
                }, [
                    m('option', {
                        value: 'RUB',
                        selected: Storage.set[Storage.show]['amountCurrency'] == 'RUB' ? 'selected' : ''
                    }, 'RUB'),
                    m('option', {
                        value: 'USD',
                        selected: Storage.set[Storage.show]['amountCurrency'] == 'USD' ? 'selected' : ''
                    }, 'USD'),
                    m('option', {
                        value: 'EUR',
                        selected: Storage.set[Storage.show]['amountCurrency'] == 'EUR' ? 'selected' : ''
                    }, 'EUR'),
                ])),
                m('td', {
                    style: {display: 'inline-block'}
                }, [
                    m('span', 'из поля: '),
                    m('input[type=checkbox]', {
                        class: 'checkbox-yandex-table-component',
                        checked: Storage.set[Storage.show]['checked'] == 1 ? 'checked' : '',
                        onclick: function(e) {
                            Storage.set[Storage.show]['checked'] = e.target.checked ? 1 : 0
                        }
                    })
                ]),
                (Storage.set[Storage.show]['checked'] ? m('td', {
                    style: {display: 'inline-block'}
                }, m(Select, {
                    set: Storage.set[Storage.show]['amountCurrency_field'] == undefined ? '' : Storage.set[Storage.show]['amountCurrency_field'],
                    typeField: 3,
                    value: Storage.set[Storage.show]['amountCurrency_field'] == undefined ? 0 : Storage.set[Storage.show]['amountCurrency_field'],
                    onchange: function(e) {
                        Storage.set[Storage.show]['amountCurrency_field'] = e.target.value == '' ? 0 : e.target.value;
                    },
                })) : m('td', { style: {display: 'inline-block'}}, ))
            ]),
            m('tr', [
                m('td[width=45%][align=right][colspan=2]', m(HelpComponent, { name: 'Описание платежа', hId: 'module_yandex_payment_description' })),
                m('td[colspan=3]', m(Select, {
                    set: Storage.set[Storage.show]['description'] == undefined ? '' : Storage.set[Storage.show]['description'],
                    typeField: 3,
                    value: Storage.set[Storage.show]['description'] == undefined ? 0 : Storage.set[Storage.show]['description'],
                    onchange: function(e) {
                        Storage.set[Storage.show]['description'] = e.target.value == '' ? 0 : e.target.value;
                    },
                }))
            ]),
            m('tr', [
                m('td[width=45%][align=right][colspan=2]', m(HelpComponent, { name: 'Оплаченная сумма', hId: 'module_yandex_payment_paid' })),
                m('td[colspan=3]', m(Select, {
                    set: Storage.set[Storage.show]['paid'] == undefined ? '' : Storage.set[Storage.show]['paid'],
                    typeField: 1,
                    value: Storage.set[Storage.show]['paid'] == undefined ? 0 : Storage.set[Storage.show]['paid'],
                    onchange: function(e) {
                        Storage.set[Storage.show]['paid'] = e.target.value == '' ? 0 : e.target.value;
                    },
                }))
            ]),
            m('tr', [
                m('td[width=45%][align=right][colspan=2]', m(HelpComponent, { name: 'Дата платежа', hId: 'module_yandex_payment_date' })),
                m('td[colspan=3]', m(Select, {
                    set: Storage.set[Storage.show]['date'] == undefined ? '' : Storage.set[Storage.show]['date'],
                    typeField: 2,
                    value: Storage.set[Storage.show]['date'] == undefined ? 0 : Storage.set[Storage.show]['date'],
                    onchange: function(e) {
                        Storage.set[Storage.show]['date'] = e.target.value == '' ? 0 : e.target.value;
                    },
                }))
            ]),
            m('tr', [
                m('td[width=45%][align=right][colspan=2]', {
                    class: Storage.set[Storage.show]['status'] == undefined || Storage.set[Storage.show]['status'] == 0 ? '' : 'module_yandex_payment_status'
                }, m(HelpComponent, { name: 'Статус платежа', hId: 'module_yandex_payment_status' })),
                m('td[colspan=3]', {
                    class: Storage.set[Storage.show]['status'] == undefined || Storage.set[Storage.show]['status'] == 0 ? '' : 'module_yandex_payment_status'
                }, m(Select, {
                    set: Storage.set[Storage.show]['status'] == undefined ? '' : Storage.set[Storage.show]['status'],
                    typeField: 4,
                    value: Storage.set[Storage.show]['status'] == undefined ? 0 : Storage.set[Storage.show]['status'],
                    onchange: function(e) {
                        Storage.set[Storage.show]['status'] = e.target.value == '' ? 0 : e.target.value;
                    },
                }))
            ]),
            (Storage.set[Storage.show]['status'] == undefined || Storage.set[Storage.show]['status'] == 0 ? '' : statusArray()),
            m('tr', [
                m('td[width=45%][align=right][colspan=2]', m(HelpComponent, { name: 'Автоприем платежа (рекомендуется по умолчанию)', hId: 'module_yandex_payment_capture' })),
                m('td[colspan=3]', m('input[type=checkbox]', {
                    class: 'checkbox-yandex-table-component',
                    checked: Storage.set[Storage.show]['capture'] == 1 ? 'checked' : '',
                    onclick: function(e) {
                        Storage.set[Storage.show]['capture'] = e.target.checked ? 1 : 0
                    }
                }))
            ]),
            m('tr', [
                m('td[width=45%][align=right][colspan=2]', m(HelpComponent, { name: 'Автогенерация ссылок', hId: 'module_yandex_payment_confirmation_url' })),
                m('td[colspan=3]', m('input[type=checkbox]', {
                    class: 'checkbox-yandex-table-component',
                    checked: Storage.set[Storage.show]['confirmation_url'] == 1 ? 'checked' : '',
                    onclick: function(e) {
                        Storage.set[Storage.show]['confirmation_url'] = e.target.checked ? 1 : 0
                    }
                }))
            ]),
            confirmationUrlArray(),
            m('tr', [
                m('td[width=45%][align=right][colspan=2]', m(HelpComponent, { name: 'Собственные ссылки на оплату', hId: 'module_yandex_payment_where_to_redirect' })),
                m('td[colspan=3]', m('input[type=checkbox]', {
                    class: 'checkbox-yandex-table-component',
                    checked: Storage.set[Storage.show]['where_to_redirect'] == undefined ? 0 : (Storage.set[Storage.show]['where_to_redirect'] == 1 ? 'checked' : ''),
                    onclick: function(e) {
                        Storage.set[Storage.show]['where_to_redirect'] = e.target.checked ? 1 : 0;
                        if (Storage.set[Storage.show]['where_to_redirect'] == 0) Storage.set[Storage.show]['link_expiration_date'] = 0;
                        if (
                            Storage.set[Storage.show]['where_to_redirect'] == 1 &&
                            (
                                Storage.set[Storage.show]['link_expiration_date'] == undefined ||
                                Storage.set[Storage.show]['link_expiration_date'] == 0
                            )
                        ) Storage.set[Storage.show]['link_expiration_date'] = 1;
                    }
                }))
            ]),
            (Storage.set[Storage.show]['where_to_redirect'] != 1 ? '': m('tr', [
                m('td[width=45%][align=right][colspan=2]', m(HelpComponent, { name: 'Срок действия ссылки', hId: 'module_yandex_payment_link_expiration_date' })),
                m('td[colspan=3]', m('select', {
                    class: 'form-control form-control-250',
                    value: vnode.attrs.value,
                    onchange: function(e) { Storage.set[Storage.show]['link_expiration_date'] = e.target.value; }
                }, [
                  m('option', {value: 2, selected: Storage.set[Storage.show]['link_expiration_date'] == 2 ? 'selected' : ''}, 'Один час'),
                  m('option', {value: 3, selected: Storage.set[Storage.show]['link_expiration_date'] == 3 ? 'selected' : ''}, 'Три часа'),
                  m('option', {value: 4, selected: Storage.set[Storage.show]['link_expiration_date'] == 4 ? 'selected' : ''}, 'Сутки'),
                  m('option', {value: 1, selected: Storage.set[Storage.show]['link_expiration_date'] == 1 ? 'selected' : ''}, 'Три дня'),
                  m('option', {value: 5, selected: Storage.set[Storage.show]['link_expiration_date'] == 5 ? 'selected' : ''}, 'Вечно'),
                ]))
            ])),

            /* задание 86839 */
            m('tr', {style: 'height: 20px;'}, m('td[colspan=5]')),

            m('tr', [
                m('td[width=45%][align=right][colspan=2]', m(HelpComponent, {
                    name: 'Данные для формирования чека в онлайн-кассе (для соблюдения 54-ФЗ)',
                    hId: 'module_yandex_formation_check'
                })),
                m('td[colspan=3]', m('input[type=checkbox]', {
                    class: 'checkbox-yandex-table-component',
                    checked: Storage.set[Storage.show]['formation_check'] == undefined ? 0 : (Storage.set[Storage.show]['formation_check'] == 1 ? 'checked' : ''),
                    onclick: function(e) {
                        Storage.set[Storage.show]['formation_check'] = e.target.checked ? 1 : 0;

                        // TODO очищаю все данные о подтаблице
                        if (Storage.set[Storage.show]['formation_check'] == 0) {
                          clearSubtableSettings(true);
                        }
                    }
                }))
            ]),

            Storage.set[Storage.show]['formation_check'] == undefined || Storage.set[Storage.show]['formation_check'] == 0 ? null : [
              m('tr', [
                  m('td[width=45%][align=right][colspan=2]', m(HelpComponent, {
                    name: 'Email для отправки чека',
                    hId: 'module_yandex_payment_subtable_email'
                  })),
                  m('td[colspan=3]', m(Select, {
                      set: Storage.set[Storage.show]['subtable_email'] == undefined ? '' : Storage.set[Storage.show]['subtable_email'],
                      typeField: 3,
                      value: Storage.set[Storage.show]['subtable_email'] == undefined ? 0 : Storage.set[Storage.show]['subtable_email'],
                      onchange: function(e) {
                        Storage.set[Storage.show]['subtable_email'] = e.target.value == '' ? 0 : e.target.value;
                      },
                  }))
              ]),

              // https://yookassa.ru/developers/payment-acceptance/receipts/54fz/parameters-values#payment-subject
              m('tr', [
                m('td[width=45%][align=right][colspan=2]', m(HelpComponent, {name: 'Признак предмета расчета', hId: 'module_yookassa__payment_subject'})),

                m('td[colspan=3]', m('select', {
                  class: 'form-control form-control-250',
                  id: 'module_yookassa__payment_subject',
                  value: vnode.attrs.value,
                  onchange: function(e) { Storage.set[Storage.show]['payment_subject'] = e.target.value; }
                }, [
                  m('optgroup[label="Версия ФФД 1,05"]', PaymentSubjectOptions["1.05"].map(function (item) {
                    return m('option', {
                      value: item.value,
                      selected: (Storage.set[Storage.show]['payment_subject'] == item.value ? 'selected' : '')
                    }, item.description);
                  })),

                  m('optgroup[label="Версия ФФД 1,2"]', PaymentSubjectOptions["1.2"].map(function (item) {
                    return m('option', {
                      value: item.value,
                      selected: (Storage.set[Storage.show]['payment_subject'] == item.value ? 'selected' : '')
                    }, item.description);
                  }))
                ])),
              ]),

              // https://yookassa.ru/developers/payment-acceptance/receipts/54fz/parameters-values#payment-mode
              m('tr', [
                m('td[width=45%][align=right][colspan=2]', m(HelpComponent, {name: 'Признак способа расчета', hId: 'module_yookassa__payment_mode'})),

                m('td[colspan=3]', m('select', {
                  class: 'form-control form-control-250',
                  value: vnode.attrs.value,
                  onchange: function(e) { Storage.set[Storage.show]['payment_mode'] = e.target.value; }
                }, PaymentModeOptions.map(function (item) {
                  return m('option', {
                    value: item.value,
                    selected: (Storage.set[Storage.show]['payment_mode'] == item.value ? 'selected' : '')
                  }, item.description);
                }))),
              ]),

              m('tr', [
                m('td[width=45%][align=right][colspan=2]', m(HelpComponent, { name: 'Подтаблица', hId: 'module_yandex_payment_subtable' })),
                m('td[colspan=3]', m('select', {
                    class: 'form-control form-control-250',
                    value: vnode.attrs.value,
                    onchange: function(e) {
                      if (Storage.set[Storage.show]['subtable'] != e.target.value) {
                        clearSubtableSettings();
                      }
                      Storage.set[Storage.show]['subtable'] = e.target.value;
                    }
                }, Metadata.getSubtables()))
              ]),
              Storage.set[Storage.show]['subtable'] == undefined || Storage.set[Storage.show]['subtable'] == 0 ? null : [
                m('tr', [
                  m('td[width=45%][align=right][colspan=2]', m(HelpComponent, { name: 'Название товара', hId: 'module_yandex_payment_subtable_description' })),
                  m('td[colspan=3]', m('select', {
                      class: 'form-control form-control-250',
                      value: vnode.attrs.value,
                      onchange: function(e) { Storage.set[Storage.show]['subtable_description'] = e.target.value; }
                  }, Metadata.getSubtableField('subtable_description')))
                ]),
                m('tr', [
                    m('td[width=45%][align=right][colspan=2]', m(HelpComponent, { name: 'Количество товара', hId: 'module_yandex_payment_subtable_quantity' })),
                    m('td[colspan=3]', m('select', {
                        class: 'form-control form-control-250',
                        value: vnode.attrs.value,
                        onchange: function(e) { Storage.set[Storage.show]['subtable_quantity'] = e.target.value; }
                    }, Metadata.getSubtableField('subtable_quantity', [1,3])))
                ]),
                m('tr', [
                    m('td[width=45%][align=right][colspan=2]', m(HelpComponent, { name: 'Цена товара', hId: 'module_yandex_payment_subtable_amount_value' })),
                    m('td[colspan=3]', m('select', {
                        class: 'form-control form-control-250',
                        value: vnode.attrs.value,
                        onchange: function(e) { Storage.set[Storage.show]['subtable_amount_value'] = e.target.value; }
                    }, Metadata.getSubtableField('subtable_amount_value', [1,3])))
                ]),
                m('tr', [
                    m('td[width=45%][align=right][colspan=2]', m(HelpComponent, { name: 'Ставка НДС', hId: 'module_yandex_payment_subtable_vat_code' })),
                    m('td[colspan=3]', m('select', {
                        class: 'form-control form-control-250',
                        value: vnode.attrs.value,
                        onchange: function(e) { Storage.set[Storage.show]['subtable_vat_code'] = e.target.value; }
                    }, Metadata.getSubtableField('subtable_vat_code', [1,3,4])))
                ])
              ]
            ]
        ];
    }
};

function clearSubtableSettings(clear_email = false) {
  if (clear_email) Storage.set[Storage.show]['subtable_email'] = 0;
  Storage.set[Storage.show]['subtable'] = 0;
  Storage.set[Storage.show]['subtable_description'] = 0;
  Storage.set[Storage.show]['subtable_quantity'] = 0;
  Storage.set[Storage.show]['subtable_amount_value'] = 0;
  Storage.set[Storage.show]['subtable_vat_code'] = 0;
}

const Metadata = {
  getSubtables() {
    let subtables = Storage.subtables[Storage.set[Storage.show]?.table] || {};

    return [
      m('option', {value: 0, selected: Storage.set[Storage.show]['subtable'] == 1 ? 'selected' : ''}, '')
    ].concat(Object.keys(subtables).map(idx => {
      return m('option', {
        value: subtables[idx]['id'],
        selected: Storage.set[Storage.show]['subtable'] == subtables[idx]['id'] ? 'selected' : ''
      }, subtables[idx]['name'])
    }));
  },

  getSubtableField(ident, types = [3]) {
    let subtable = Storage.subtables[Storage.set[Storage.show]?.table] == undefined
      ? {} : Storage.subtables[Storage.set[Storage.show]?.table][Storage.set[Storage.show]?.subtable] || {};

    let subtable_fields = Storage.fields["subtables"] == undefined ? {} : Storage.fields["subtables"][subtable["id"]]["fields"];

    return [
      m('option', {value: 0, selected: Storage.set[Storage.show]['subtable'] == 0 ? 'selected' : ''}, '')
    ].concat(Object.keys(subtable_fields).map(idx => {
      if (types != [] && !types.includes(Number(subtable_fields[idx]['type_field']))) {
        return;
      }
      return m('option', {
        value: subtable_fields[idx]['id'],
        selected: Storage.set[Storage.show][ident] == subtable_fields[idx]['id'] ? 'selected' : ''
      }, subtable_fields[idx]['name_field'])
    }));
  }
}

let TableComponent = {
    view: function() {
        return Storage.show == 0 ? m('div') : m('div', {}, m('table[width=100%]', [
            m('tr', [
                m('td[width=45%][align=right][colspan=2]', m(HelpComponent, { name: 'Таблица-получатель', hId: 'module_yandex_payment_recipient_table' })),
                m('td[colspan=3]', m(TableSelect, {
                    num: Storage.show,
                    selectedTable: Storage.set[Storage.show] == undefined ? 0 : Storage.set[Storage.show]['table']
                }))
            ]),
            (Storage.set[Storage.show]['table'] == 0 ? '' : m(ManyPropertiesComponent, {
              onupdate: function() {
                // $('#module_yookassa__payment_subject').chosen()
              },
                table: Storage.set[Storage.show]['table']
            }))
        ]));
    }
}

let Components = {
    inputText: {
        view: function(vnode) {
            return m('div', {
                class: vnode.attrs.class
            }, [
                m('label', vnode.attrs.label),
                m('input[type=text]', {
                    value: vnode.attrs.value,
                    onblur: vnode.attrs.onblur instanceof Function ? vnode.attrs.onchange : function() {}
                })
            ])
        }
    },

    displayingKey: {
        view: function(vnode) {
            return m('div', [
                m('a', {
                    onclick: vnode.attrs.onclick instanceof Function ? vnode.attrs.onchange : function() {}
                }, m('img', { src: 'images/b_drop.png', title: 'Удалить' })),
                m('span', vnode.attrs.text + ': ' + vnode.attrs.key),
            ])
        }
    },

    select: {
        view: function(vnode) {
            let arr = new Array
            if (vnode.attrs.emp) arr.push(m('option', vnode.attrs.empText))
            for (let i in vnode.attrs.arr) {
                arr.push(m('option', {
                    value: vnode.attrs.arr[i][vnode.attrs.val],
                    selected: vnode.attrs.arr[i][vnode.attrs.val] == vnode.attrs.sel ? vnode.attrs.arr[i][vnode.attrs.val] : ''
                }, vnode.attrs.arr[i][vnode.attrs.text]))
            }
            return m('select', {
                class: 'form-control form-control-250',
                onchange: vnode.attrs.onchange instanceof Function ? vnode.attrs.onchange : function() {}
            }, arr)
        }
    },
}

let cb_groups = [];
let access_component_pending = true;
const AccessComponent = {
  oninit: async function() {
    m.request({url: "./modules/yandex_payment/get-data.php?groups"})
    .then(function(data) {
      cb_groups = data || [];
      access_component_pending = false;
    });
  },

  view: function() {
    return access_component_pending ? [] : [
      m('br'),
      m('div[class=access-component]', [
        m('div', 'Группы доступа'),
        ...(function(groups) {
          let arr = [];
          groups.forEach(group => {
            arr.push(m('div[class=access-component__div]', [
              m('input[type=checkbox]', {
                value: group.id,
                checked: Storage.groups.includes(group.id),
                onclick: function(e) {
                  if (Storage.groups.includes(e.target.value)) {
                    _.remove(Storage.groups, n => n == e.target.value);
                  } else {
                    Storage.groups.push(e.target.value);
                  }
                }
              }),
              m('span', group.name)
            ]));
          });
          return arr;
        })(cb_groups)
      ])
    ]
  }
}

let BaseComponent = {
    view: function(vnode) {
        return [
            m(KeyComponent),
            (Storage.loading ? '' : m('hr')),
            (Storage.loading ? '' : m(ListTableComponent)),
            (Storage.loading ? '' : m(TableComponent)),
            m(AccessComponent),
            (Storage.loading ? '' : m('div', {}, m('table[width=100%]', m('tr', [
                m('td[colspan=2][align=center]', m('button', {
                    class: 'btn btn-default btn-sm',
                    onclick: function() {
                        if (Storage.shopId['value'] == '') {
                            jalert('Незаполнен идентификатор магазина');
                        } else if (Storage.apiKey['value'] == '') {
                            jalert('Не заполнен ключ API');
                        } else if (Storage.shopId['code'] == 1 && Storage.apiKey['code'] == 1) {
                            Storage.save();
                        } else if (Storage.shopId['value'] != '' && Storage.apiKey['value'] != '') {
                            Storage.checkConnection(Storage.shopId['value'], Storage.apiKey['value']);
                            Storage.flag = 1;
                        }
                    }
                }, 'Сохранить'))
            ]))))
        ];
    }
}
