import useScopedStyleMixin from '../../../useScopedStyleMixin.js'
import EditFilterStyles from './EditFilterStyles.js'

const ListFilter = {
  template: /*html*/`
    <section 
      :class="componentClass + hash"
    >
      <template v-for="(filterCategory, index) in filterCategories">
        <button 
          @click="$emit(filterCategory.emit)"
          :class="[
            componentClass + hash + '__button', 
            { 'active': isActive(filterCategory) },
            { 'disabled': filterCategory.isDisabled },
          ]"
          :disabled="filterCategory.isDisabled"
        >
          {{ filterCategory.title }}
        </button>
        <span v-if="isBeetween(index)">/</span>
      </template>
    </section>
  `,
  data() {
    return {
      componentClass: 'edit-filter',
    };
  },
  props: {
    filter: Boolean,
    filterCategories: Array
  },
  name: 'edit-listfilter',
  mixins: [useScopedStyleMixin, EditFilterStyles],
  computed: {
    isBeetween() {
      return (index) =>
        index < this.filterCategories.length - 1
    },
    isActive() {
      return (filterCategory) => {
        const filterValue = filterCategory.filterValue;
        return filterValue === this.filter
      }
    }
  }
};

export default ListFilter;