import { useEditFormStore } from "../store/storeForm.js";

export const formBaseElement = {
  props: {
    element: Object,
    dataSource: Object,
    fieldsSource: Object      
  },
  data() {
    const store = useEditFormStore();
    const actualFieldsSource = this.fieldsSource || store.fields;
    const { data } = Pinia.storeToRefs(store);
    const actualDataSource = this.dataSource || data;
    var hidden = true;

    //Для listform
    var field = null;
    var formFieldsSource = null;
    if (this.element.field) {
      field = this.element.field;
      formFieldsSource = actualFieldsSource[field];
    }
    return {
      store,
      actualFieldsSource,
      actualDataSource,
      hidden,
      field,
      formFieldsSource,
      data
    }
  },
  computed: {
    toggleLink: function() {
      return this.element['toggle'];
    },
    toggleShow: function() {
      return !this.element['toggle'] || !this.hidden;
    },
    showOn() {
      
      const { showOn, showOnValue, hideOn, hideOnValue } = this.element;
        
      const showValue = this.actualDataSource?.[showOn];
      const hideValue = this.actualDataSource?.[hideOn];
    
      let isShow = true;
      if (showOn) {
        isShow = showOnValue === undefined ? !!showValue : showOnValue.includes(showValue);
      }
    
      if (hideOn) {
        isShow = hideOnValue === undefined ? !hideValue : !hideOnValue.includes(hideValue);
      }
      
      return isShow;
    },
  },
  methods: {
    toggle(e) {
      e.preventDefault();
      this.hidden = !this.hidden;
    },
    linesFromFields() {
      if (this.element.fields) {
        this.element.formLines = this.element.formLines || [];
        for (var fieldId in this.element.fields) {
          let field = this.element.fields[fieldId];
          this.element.formLines.push({
            "label": field,
            "fields": [field]
          });
        }
        delete this.element.fields;
      }
    },
    blocksFromLines() {
      if (this.element.formLines) {
        this.element.formBlocks = this.element.formBlocks || [];
        this.element.formBlocks.push({
          "formLines": this.element.formLines
        });
        delete this.element.formLines;
      }
    },
    formsFromBlocks() {
      if (this.element.formBlocks) {
        this.element.forms = this.element.forms || [];
        this.element.forms.push({
          "formBlocks": this.element.formBlocks
        });
        delete this.element.formBlocks;
      }
    }
  },
};
