import { FIELD_LINK } from "../../../constants.js"


/** Поля в карточке */
export default {
  props: ["fields", "table", "cardId"],

  setup(props, {emit}) {
    return {
      fieldTypes: { file: 6 , image: 9 },

      buildText(field_info, value) {
        switch (field_info['type_field']) {
          case FIELD_LINK:
            let data = new Array;

            if (field_info['mult_value'] == 1) {
              if (typeof value[0] !== 'undefined' && value[0] != null) {
                let json = JSON.parse(value[0]);
                json?.forEach((item) => {
                  data.push(item.text || '')
                })
              }

              return [data.join("<br>")];
            } else {
              return value;
            }

          default: return value;
        }
      }
    }
  },

  template: /*html*/`
    <template v-for="field of fields">
      <div
        v-if="field.field_id !== null"
        :class="{'main-users_carts-content-items--text': true,'itemsHidden':field.hidden}"
      >
        <template v-if="field.name"><div style="align-self: baseline;overflow-wrap: break-word;">{{ field.name }}:</div></template>

        <template v-if="field.type_field != fieldTypes.file && field.type_field != fieldTypes.image">
          <template v-for="item of buildText(field, field.value)">
            <div v-html="item"></div>
          </template>
        </template>

        <div v-else-if="field.type_field == fieldTypes.file">
          <fileFields
            :table="table"
            :id="cardId"
            :field="field"
          />
        </div>

        <div v-else>
          <imageFields
            :table="table"
            :id="cardId"
            :field="field"
          />
        </div>
      </div>
    </template>
  `
}
