import card from './card.js';
import addCard from './addCard.js';

/** Столбец */
export default{
  props: ['column','len','data','settings', 'kanban_id', 'title_height'],

  components: {
    card,
    addCard,
    draggable: window.vuedraggable
  },

  data () {
      return {
          addCardShow: false,
          style: `width:calc(100%/${this.len});`,
          requestOptions: {
              method: 'PATCH',
              credentials: "include",//включение кук в запрос
              redirect: 'follow'
          },
          type: "data"+this.settings.table,
          oldBorderColor: ''
      }
  },

  methods: {
      addCardItem (el) {
          // добавление карточки
          el['id'] = this.column.cards.length
          this.column.cards.push(el)
          this.addCardShow = false
      },
      deleteCard (id) {
          // удаление карточки
          this.column.cards = this.column.cards.filter(e => e.id !== id)
      },
      addCansel () {
          // отмена добавления карточки
          this.addCardShow = false
      },
      checkMove: function (evt) {
          //начало перетаскивания

          if(this.kanban_id != evt.to.parentElement.attributes?.kanban_id?.value){
              return false;
          }

          let color = evt.to.parentElement.attributes?.color?.value?.split(')')[0] || '';
          color = (color != '') ? `${color.replace('rgb', 'rgba')}, 0.05)` : 'rgba(150,150,150,0.05)'
          evt.dragged.style.backgroundColor = color // закрашиваем место куда навели карточку
          evt.dragged.style.border = 'none'
          evt.dragged.style.color = 'transparent'
      },
      sortEvt: function (evt) {
          // console.log(evt);
      },
      startEvt: function (evt) {
          this.oldBorderColor = (evt.item.style.borderColor !== '') ? evt.item.style.borderColor : '#dce2e6'
      },
      endEvt: function (evt) {
          let myHeaders = new Headers(),
              attributes = {},
              old_stat = evt.from.parentElement.attributes?.column_title?.value || '',
              new_stat = evt.to.parentElement.attributes?.column_title?.value || '',
              _kanban_id = evt.to.parentElement.attributes?.kanban_id?.value || '';


          if(this.kanban_id != _kanban_id){
              return false;
          }
          myHeaders.append("Content-Type", "application/vnd.api+json")
          myHeaders.append("X-Auth-Token", window.x_auth_token)
          this.requestOptions['headers'] = myHeaders

          //новое значение у поля группировки
          if (this.settings.field_type == 2) {
              let format = lang.date_js_format.toUpperCase() + "YY"
              attributes[this.settings.field_id] = moment(new_stat, format).format("YYYY-MM-DD 00:00:00")
          } else {
              attributes[this.settings.field_id] = new_stat
          }
          let line_id = evt.to.childNodes[evt.newIndex].attributes.card_id.value
          this.requestOptions['body'] = JSON.stringify({
              "data": {
                  "type": this.type,
                  "id": line_id,
                  "attributes": attributes
              }
          })

          fetch("./api/dev/"+this.type+"/"+line_id, this.requestOptions) // отправка запроса
          .then(response => response.text())
          .catch(error => console.log('error', error))

          //окончание перетаскивания
          evt.to.childNodes[evt.newIndex].childNodes[0].style.backgroundColor = 'white' // убираем закрашивания карточки
          evt.to.childNodes[evt.newIndex].childNodes[0].style.color = ''
          evt.to.childNodes[evt.newIndex].style.backgroundColor = 'white' // убираем закрашивания карточки
          evt.to.childNodes[evt.newIndex].style.color = ''
          if (old_stat != new_stat) {
              let item = evt.to.childNodes[evt.newIndex],
                  card = this.data[this.translit(evt.to.parentElement.attributes?.column_text?.value || '')].cards[evt.newIndex]

              item.classList.remove('move')
              setTimeout(function(){
                  item.classList.add('move')
                  if (card.title.field_id === this.settings.field_id.replace('f','')) {
                      card.title.value = evt.to.parentElement.attributes.column_text.value
                  }
                  for (let id in card.other_fields) {
                      if (card.other_fields[id].field_id === this.settings.field_id.replace('f','')) {
                          card.other_fields[id].value[0] = evt.to.parentElement.attributes.column_text.value
                      }
                  }
                  displayNotification(lang.save_value_notify, 1) //убираем желтую подсветку и выводим напоминание
              }.bind(this), 1000)
          } else {
              //evt.to.childNodes[evt.newIndex].style.border = `1px solid ${this.oldBorderColor}`;
          }
      },
      translit (str) {
          let Chars = {
              'а': 'a', 'б': 'b', 'в': 'v', 'г': 'g', 'д': 'd', 'е': 'e', 'ё': 'yo', 'ж': 'zh', 'з': 'z', 'и': 'i', 'й': 'y', 'к': 'k', 'л': 'l', 'м': 'm', 'н': 'n', 'о': 'o', 'п': 'p', 'р': 'r', 'с': 's', 'т': 't', 'у': 'u', 'ф': 'f', 'х': 'h', 'ц': 'c', 'ч': 'ch', 'ш': 'sh', 'щ': 'shch', 'ъ': '', 'ы': 'y', 'ь': '', 'э': 'e', 'ю': 'yu', 'я': 'ya', 'А': 'A', 'Б': 'B', 'В': 'V', 'Г': 'G', 'Д': 'D', 'Е': 'E', 'Ё': 'YO', 'Ж': 'ZH', 'З': 'Z', 'И': 'I', 'Й': 'Y', 'К': 'K', 'Л': 'L', 'М': 'M', 'Н': 'N', 'О': 'O', 'П': 'P', 'Р': 'R', 'С': 'S', 'Т': 'T', 'У': 'U', 'Ф': 'F', 'Х': 'H', 'Ц': 'C', 'Ч': 'CH', 'Ш': 'SH', 'Щ': 'SHCH', 'Ъ': '', 'Ы': 'Y', 'Ь': '', 'Э': 'E', 'Ю': 'YU', 'Я': 'YA', ' ': '_'
          },
          t = str;
          for (var i in Chars) {
              t = t.replace(new RegExp(i, 'g'), Chars[i]);
          }
          return t;
      },
      updateData(){
          this.$emit('update_data');
      },
  },

  computed: {
      getColor () {
          let color = this.column?.color?.split(')')[0] || '';
          color = (this.settings.whatPaint != 'without_color' && color != '') ? `background-color: ${color}, 0.3)` : ''
          return color;
      },
      getTitleStyle(){
          return 'height: ' + this.title_height + 'px; min-height: ' + this.title_height + 'px;';
      },
  },

  template: /*html*/`
    <div
      class="main-users_carts"
      :kanban_id="kanban_id"
      :column_title="column.write_data"
      :column_text="column.title.value"
      :color="column.color"
      :style="style"
      v-on="$listeners"
    >
      <div class="main-users_carts-header" :style="getTitleStyle">
        <div class="main-users_carts-header_item" :style="getColor">{{ column.title.value }}</div>
      </div>

      <draggable
        class="list-group"
        :list="column.cards"
        handle=".move"
        group="people"
        :sort="true"
        :move="checkMove"
        @start="startEvt"
        @end="endEvt"
        @sort="sortEvt"
        itemKey="id"
      >
        <template #item="{ element, index }">
          <card
            :card="element"
            @deleteCard="deleteCard"
            :settings="settings"
            :getColor="column.color"
            @update_data="updateData"
          />
        </template>
      </draggable>

      <addCard
        v-if="addCardShow"
        @addCardItem="addCardItem"
        @addCansel="addCansel"
      />
    </div>
  `
}
