/**
 * presence-in-calculations - присутствие в вычислениях
 */

export default Vue.defineCustomElement({
  props: {
    calcs: {
      type: String,
      required: false,
      default: ''
    },

    buttons: {
      type: String,
      required: false,
      default: ''
    },

    crons: {
      type: String,
      required: false,
      default: ''
    }
  },

  setup(props) {
    return {
      getAllItems() {
        let result = {
          calcs:   JSON.parse(props.calcs) || [],
          buttons: JSON.parse(props.buttons) || [],
          Crons:   JSON.parse(props.crons) || [],
        };
        return result;
      },

      getCaptionName(name) {
        switch(name) {
          case 'calcs':   return lang.Calcs;
          case 'buttons': return lang.Buttons;
          default:        return name;
        }
      },

      buildFirstHref(name, id) {
        switch(name) {
          case 'calcs':   return `edit_calc.php?calc_id=${id}`;
          case 'buttons': return `edit_button.php?button=${id}`;
          case 'Crons':   return `edit_cron.php?cron_id=${id}`;
        }
      },

      buildSecondHref(name, id) {
        switch(name) {
          case 'calcs':   return `open_calc('calc_id=${id}',0);return false;`;
          case 'buttons': return `open_calc('part=button_php&button=${id}',0);return false;`;
          case 'Crons':   return `open_calc('cron_id=${id}&part=cron_php',0);return false;`;
        }
      }
    };
  },

  template: /*html*/`
    <div class="container">
      <input type="text" class="form-input" value="php" readonly>
      <div class="block">
        <div class="block__item" v-for="(items, index) in getAllItems()">
          <p
            v-if="items.length > 0"
            class="block__item__caption"
          >{{getCaptionName(index)}}:</p>
          <template v-for="item in items">
            <div class="block__item__body">
              <div class="navigate-block">
                <span>
                  <a
                    :href="buildFirstHref(index, item.id)"
                    target="_blank"
                  >{{ item.name }}</a>
                </span>
                <span class="navigate-block__code"> (<a
                  :onclick="buildSecondHref(index, item.id)"
                >${lang.Code}</a>)</span>
              </div>
            </div>
          </template>
        </div>
      </div>
    </div>
  `,

  styles: [/*css*/`
    .container {
      display: inline-block;
      position: relative;
      font-size: 13px;
      font-weight: normal;
    }

    input, input:focus, input:active, input:focus-visible, input:hover {
      width: 24px;
      border: none;
      color: black;
      outline: none;
      cursor: pointer;
      caret-color: transparent;
      padding-top: 3px;
      margin-left: 30px;
      display: inline-block;
      outline: none;
      cursor: pointer;
      color: #7CC86B;
      text-decoration: underline;
      font-style: normal;
      position: relative;
      top: -1px;
    }

    input:hover {
      background-color: #7CC86B;
      color: white;
    }

    .block {
      display: none;
      position: absolute;
      text-align: left;
      opacity: 1;
      cursor: default;
      width: 250px;
      white-space: normal;
      background: #fff;
      border: 1px solid #CCCCCC;
      padding: 10px;
      left: 30px;
      position: absolute;
      box-shadow: 1px 1px 5px rgb(0 0 0 / 20%);
      z-index: 9999;
    }

    .block:hover {
      display: block;
    }

    input:focus + .block {
      display: block;
    }

    .block__item {
      font-style: italic;
      margin-bottom: 10px;
    }

    .block div.block__item:last-child {
      margin-bottom: 0px;
    }

    .block__item__caption {
      color: grey;
      margin: 0;
    }

    .block__item__body a {
      text-decoration: none;
      outline: none;
      cursor: pointer;
      color: blue;
    }

    .navigate-block__code {
      color: grey;
    }

    .navigate-block span a:hover {
      color: #23527c;
    }
  `],
});
