'use strict';


/** Подписать страницу на события */
export function localStorageListeners(prefix) {
  function setStoreValue(name, value, use_local_storage) {
    CB.store.useStore().dispatch(prefix + '/setValue', {
      name  : name,
      data  : value,
      useLS : use_local_storage,
    });
  }

  function getStoreValue(name) {
    return CB.store.useStore().state[prefix][name];
  }

  window.addEventListener('storage', function(event) {
    let prefix_ = prefix + '_';

    // если изменился на другой вкладке объект звонка, изменяем и на текущей
    if (event.key == prefix_ + 'Call') {
      let callEvent = JSON.parse(event.newValue);

      // провайдер
      if (callEvent.provaider) {
        setStoreValue('currentProvaider', callEvent.provaider, true);
      }

      // номер телефона
      if (callEvent.numberForCall) {
        setStoreValue('phone_number', callEvent.numberForCall, true);
      }

      // информация об исходящем звонке
      if (callEvent.outgoing) {
        // если нет флага, что нужно сбросить
        if (!callEvent.outgoing.dropCall) {
          setStoreValue('Call', callEvent, false);
        }

        // если номер исходящего звонка есть, то в свойство номер записываем его
        if (callEvent['outgoing'].number) {
          setStoreValue('phone_number', callEvent['outgoing'].number, false);
        }
      }
      // информация об входящем звонке
      else if (callEvent.incoming) {
        // если звонок принят
        if (callEvent['incoming'].incomingNumber && !callEvent['incoming'].incomingNumberGo || !callEvent.incoming.dropIncomingCall) {
          setStoreValue('Call', callEvent, true);
        }
      }

      // очищаем инфу
      if (
        !callEvent.isCall &&
        (callEvent.incoming && Object.keys(callEvent.incoming).length == 0 ||
        callEvent.outgoing && Object.keys(callEvent.outgoing).length == 0)
      ) {
        setStoreValue('is_showed_call_block', false, false);
        setStoreValue('phone_number', '', false);

        if (!document.hidden) {
          setStoreValue('is_showed_call_block', true, false);
        }

        setStoreValue('service_text', '', false);
        setStoreValue('notification_text', '', false);
        setStoreValue('is_call', false, false);
        setStoreValue('call_type', '', false);
        setStoreValue('asterisk_time', '00:00:00', false);
        setStoreValue('redirect_number', '', false);
        setStoreValue('show_redirect_block', false, false);
      }
    }

    // скрываем блок звонилки если изменился key is_showed_call_block при этом нет сходящей или исходящей сессии на вкладке
    if (event.key == prefix_ + 'is_showed_call_block') {
      setStoreValue('is_showed_call_block', JSON.parse(event.newValue), true);
    }

    if ( // все указанные ключи просто записываем в хранилище, без обновления localStorage
      event.key == prefix_ + 'user_status' ||
      event.key == prefix_ + 'users_info' ||
      event.key == prefix_ + 'provider_settings' ||
      event.key == prefix_ + 'asterisk_time' ||
      event.key == prefix_ + 'show_call_notification' ||
      event.key == prefix_ + 'notification_info' ||
      event.key == prefix_ + 'notification_text' ||
      event.key == prefix_ + 'notification_title' ||
      event.key == prefix_ + 'phone_number' ||
      event.key == prefix_ + 'service_text' ||
      event.key == prefix_ + 'is_call' ||
      event.key == prefix_ + 'call_type' ||
      event.key == prefix_ + 'call_status'
    ) {
      setStoreValue(event.key.replace(prefix_, ''), JSON.parse(event.newValue), false);
    }
  });
}
