class CalcTypes {

    constructor(calc_form, table_id) {
        if (calc_form.length > 0 && table_id) {
            this.calc_form = calc_form;
            this.table_id = table_id;
            this._type_input = undefined;
            this._subtable_input = undefined;
            this.Types = {
                1: 'current',
                2: 'sub',
                3: 'link',
                4: 'parent',
                5: 'expert'
            };
        }
    }

    set type(type) {
        this._type = type;
    }

    get type() {
        return this._type;
    }

    set calc_form(calc_form) {
        this._calc_form = calc_form;
    }

    get calc_form() {
        return this._calc_form;
    }

    set type_input(type) {
        this._type_input = type;
    }

    get type_input() {
        return this._type_input;
    }

    set subtable_input(subtable) {
        this._subtable_input = subtable;
    }

    get subtable_input() {
        return this._subtable_input;
    }

    set table_id(table_id) {
        this._table_id = table_id;
    }

    get table_id() {
        return this._table_id;
    }

    run() {
        if (this.type && this.type_input.length > 0 && this.calc_form.length > 0) {
            this.type_input.val(this.type);
            switch (this.type) {
                case 1:
                    this.current();
                    break;
                case 2:
                    this.sub();
                    break;
                case 3:
                    this.link();
                    break;
                case 4:
                    this.parent();
                    break;
                case 5:
                    this.expert();
                    break;
                default:
                    this.current();
                    break;
            }
        } else {
            console.log('invalid type or type_input or calc_form');
        }
    }

    current() {
        this.calc_form.submit();
    }

    sub() {
        let options = '';
        const subtables = this.getSubTables();
        for (const subtable in subtables) {
            options += `<option value="${subtables[subtable]['link_table_id']}">${subtables[subtable]['name']}</option>`;
        }
        $.fancybox.open(
            `<div style="padding: 50px; text-align: center;">
                <p>Выберите подтаблицу</p>
                <select class="form-control form-control-160" name="sel_subtable">${options}</select>
                <div style="margin-top: 20px;">
                    <input class="btn btn-default btn-sm" data-fancybox-close="" id="set_subtables" type="button" value="Выбрать">
                    <input class="btn btn-default btn-sm" data-fancybox-close="" type="button" value="Отмена">
                </div>
            </div>`
        );
        $('#set_subtables').click(() => {
            this.subtable_input.val($('select[name=sel_subtable]').val());
            this.calc_form.submit();
        })
    }

    link() {
        let options = '';
        const link_tables = this.getLinkTables();
        for (const table in link_tables) {
            options += `<option value="${link_tables[table]['id']}">${link_tables[table]['name_table']}</option>`;
        }
        $.fancybox.open(
            `<div style="padding: 50px; text-align: center;">
                <p>Выберите связанную таблицу</p>
                <select class="form-control form-control-160" name="sel_link_table">${options}</select>
                <div style="margin-top: 20px;">
                    <input class="btn btn-default btn-sm" data-fancybox-close="" id="set_link_table" type="button" value="Выбрать">
                    <input class="btn btn-default btn-sm" data-fancybox-close="" type="button" value="Отмена">
                </div>
            </div>`
        );
        $('#set_link_table').click(() => {
            this.subtable_input.val($('select[name=sel_link_table]').val());
            this.calc_form.submit();
        })
    }

    parent() {
        this.calc_form.submit();
    }

    expert() {
        this.calc_form.submit();
    }

    static ajaxSender(url, params) {
        return JSON.parse($.ajax({
            type: 'POST',
            url: url,
            async: false,
            data: params
        }).responseText);
    }

    getSubTables() {
        const url = 'edit_calc.php';
        const params = {
            ajax: 1,
            action: 'getSubTables',
            table: this.table_id,
            csrf: csrf,
        };
        return CalcTypes.ajaxSender(url, params);
    }

    getLinkTables() {
        const url = 'edit_calc.php';
        const params = {
            ajax: 1,
            action: 'getLinkTables',
            table: this.table_id,
            csrf: csrf,
        };
        return CalcTypes.ajaxSender(url, params);
    }

}
