<?php
// Изменение структуры синхронизации
$result = run_query("SELECT * FROM `" . $config['table_prefix'] . "sync`");
while ($row = sql_fetch_assoc($result)) {
    if ($row['type_mode']) { // Синхронизация не локальная, создаём папки в temp
        $sync_dirs_list = array(
            "sync_" . $row['id'],
            "sync_" . $row['id'] . "/export",
            "sync_" . $row['id'] . "/import",
            "sync_" . $row['id'] . "/export/files",
            "sync_" . $row['id'] . "/import/files"
        );
        foreach ($sync_dirs_list AS $one_dir) {
            if (!is_dir("temp/" . $one_dir)) {
                if (!mkdir("temp/" . $one_dir)) {
                    die("Invalid access in 'temp'");
                }
            }
        }

        if (!file_exists("temp/sync_" . $row['id'] . "/.htaccess")) { // Добавляем .htaccess
            $fh = @fopen("temp/sync_" . $row['id'] . "/.htaccess", "w");
            @fwrite($fh, "Order Deny,Allow\r\nDeny from All");
            @fclose($fh);
        }

        // Перемещаем данные из таблицы в реальные файлы
        $subresult = run_query("SELECT * FROM `" . $config['table_prefix'] . "sync_remote` WHERE `sync_id`=" . intval($row['id']));
        while ($subrow = sql_fetch_assoc($subresult)) {
            $fh = fopen("temp/sync_" . $row['id'] . "/export/" . $subrow['f_name'] . ".tmp", "w");
            if ($fh) {
                fwrite($fh, $subrow['f_data']);
                fclose($fh);
                rename("temp/sync_" . $row['id'] . "/export/" . $subrow['f_name'] . ".tmp",
                    "temp/sync_" . $row['id'] . "/export/" . $subrow['f_name']);
            }
        }
    }
    // Перемещаем файлы
    $subresult = run_query("SELECT * FROM `" . $config['table_prefix'] . "sync_files` WHERE `sync_id`=" . intval($row['id']));
    while ($subrow = sql_fetch_assoc($subresult)) {
        sync_files_export($subrow['sync_id'], $subrow['line_id'], $subrow['field_id'], $subrow['files']);
    }
}
// Удаляем таблицы синхронизаций
run_query("DROP TABLE `" . $config['table_prefix'] . "sync_lines`");
run_query("DROP TABLE `" . $config['table_prefix'] . "sync_files`");
run_query("DROP TABLE `" . $config['table_prefix'] . "sync_remote`");
run_query("DROP TABLE `" . $config['table_prefix'] . "sync_export`");
// Добавляем дополнительные поля в sync_cache
$result = run_query("SHOW COLUMNS FROM `" . $config['table_prefix'] . "sync_cache` LIKE 'id'");
if (!sql_fetch_assoc($result)) {
    run_query("ALTER TABLE `" . $config['table_prefix'] . "sync_cache` ADD `id` INT(11) NOT NULL AUTO_INCREMENT PRIMARY KEY FIRST");
}
$result = run_query("SHOW COLUMNS FROM `" . $config['table_prefix'] . "sync_cache` LIKE 'table_id'");
if (!sql_fetch_assoc($result)) {
    run_query("ALTER TABLE `" . $config['table_prefix'] . "sync_cache` ADD `table_id` INT(11) NOT NULL DEFAULT 0 AFTER `sync_id`");
}
$result = run_query("SHOW COLUMNS FROM `" . $config['table_prefix'] . "sync_cache` LIKE 'upload_count'");
if (!sql_fetch_assoc($result)) {
    run_query("ALTER TABLE `" . $config['table_prefix'] . "sync_cache` ADD `upload_count` INT(11) NOT NULL DEFAULT 0");
}
$result = run_query("SHOW COLUMNS FROM `" . $config['table_prefix'] . "sync_cache` LIKE 'last_upload'");
if (!sql_fetch_assoc($result)) {
    run_query("ALTER TABLE `" . $config['table_prefix'] . "sync_cache` ADD `last_upload` TIMESTAMP NOT NULL DEFAULT '0000-00-00 00:00:00'");
}

// Изменяем задание синхронизации в Cron, если не добавлено
$result = run_query("SELECT `id` FROM `" . $config['table_prefix'] . "cron` WHERE `command` LIKE '%sync_data(%'");
if ($row = sql_fetch_assoc($result)) {
    run_query("UPDATE `" . $config['table_prefix'] . "cron` SET `command`='sync_all(1);' WHERE `id`=" . intval($row['id']));
}
// Удаляем задание синхронизации файлов
$result = run_query("SELECT `id` FROM `" . $config['table_prefix'] . "cron` WHERE `command` LIKE '%sync_files(%'");
if ($row = sql_fetch_assoc($result)) {
    run_query("DELETE FROM `" . $config['table_prefix'] . "cron` WHERE `id`=" . intval($row['id']));
}
?>