const fields = {    
    
      
    "apps": {

        "name": {
            "type": "input-text",
            "default": "",
            "is_list_name": "app",
            "required": true,
            "help": "bank_app_name"
        },

        "auth_client_id": {
            "type": "input-text",
            "default": "",
            "required": true,
            "help": "alfabank_client_id"         
        },

        "auth_crt_cert": {
            "type": "input-file",
            "default": "",
            "required": true,
            "help": "alfabank_crt_cert"         
        },            

        "auth_crt_key": {
            "type": "input-file",
            "default": "",
            "required": true,
            "help": "alfabank_crt_key"         
        },            

        "auth_crt_password": {
            "type": "input-text",
            "default": "",
            "required": true,
            "help": "alfabank_crt_password"         
        },               

        "auth_client_secret_auto": {
            "type": "radiobutton",
            "options": {
                "no": "auth_has_secret",
                "yes": "auth_no_secret"
            },
            "required": true,
            "default": "no",
            "help": "alfabank_client_secret_auto"         
        },          
        
        "auth_client_secret": {
            "type": "input-text",
            "default": "",
            "required": true,
            "help": "alfabank_client_secret"         
        },
        
        "__oauth_button": {
            "type": "html"
        },

        "__token_expires": {
            "type": "html"
        }
        
    },

//Сопоставление таблиц КБ и объектов внешнего приложения    
    "tables": {
        "internal_object_id": {
            "type": "dropdown",
            "optionsFrom": {
                source: "tables"
            },
            "required": true,
            "help": "bank_internal_object"
        },
    },

    "connectors": {

        "name": {
            "type": "input-text",
            "default": "",
            "is_list_name": "connector",
            "required": true,
            "help": "bank_connector_name"
        },

        "external_app_id": {
            "type": "dropdown",
            "optionsFrom": {
                source: "list",
                field: "apps",
                value: "id",
                label: "name"
            },
            "required": true,
            "help": "bank_app"   
        },        

        "external_action_params_accountNumber": {
            "type": "input-text",
            "required": true,
            "help": "bank_account_number"
        },

        "cron_id_period": {
            "type": "dropdown",
            "required": true,
            "options": {
                '* * * * *': 'Ежеминутно',
                '1,15,30,45 * * * *': 'Каждые 15 минут',
                '1-59/5 * * * *': 'Каждые 5 минут',
                '1 12 * * *': 'Каждый день в 12 часов',
                '1 23 * * *': 'Каждый день в 23 часа',
                '1 3 * * *': 'Каждый день в 3 часа',
                '1 * * * *': 'Каждый час'
            },
            "default": '1 * * * *',
            "help": "bank_cron_period"
        },

        "cron": {
            type: "html",
            help: "integration_auto_cron"
        }        
        

    }

}

export default fields;