import useSaveSettings from '../../hooks/useSaveSettings.js';
import useAccessTabWazzupExtensionStore from './../../store/useAccessTabWazzupExtensionStore.js';


/**
 * Компонент "Группы доступа"
 */
export default {
  setup(props, { emit }) {
    const accessStore = useAccessTabWazzupExtensionStore();
    const metaGroups = Vue.inject('metaGroups');

    return {
      accessStore,
      metaGroups,

      // отреагировать на кнопку сохранить
      saveHandle: _ => useSaveSettings(null)
    }
  },

  template: /*html*/`
    <div class="wazzup__access-block">
      <div>{{ $t('access_groups') }}</div>
      <template
        v-for="group in metaGroups" :key="group.id"
      >
        <div class="wazzup__access-block__input">
          <input
            type="checkbox"
            :checked="accessStore.getGroup(group.id)"
            @click="accessStore.setGroup(group.id)"
          />
        </div>
        <div class="wazzup__access-block__span">
          <span>{{ group.name }}</span>
        </div>
      </template>
    </div>

    <save-button
      @click-handle="saveHandle"
    ></save-button>
  `
}
