/**
 * Хранилище настроек модуля.
 */
export default Pinia.defineStore('useWazzupExtensionStore', {
  state: () => ({
    /** @type {string} Api ключ для запросов */
    api_key: '',
    /** @type {string} Url для получения сообщений */
    webhook_uri: '',
    /** @type {boolean} Состояние активности модуля */
    is_active: false,
    /** @type {Object} Каналы для общения */
    channels: {},
    /** @type {Array} Группы доступа */
    groups: [],
    /** @type {Array} Пользователи модуля */
    users: [],
    /** @type {string} Канал для рассылки по умолчанию */
    def_chan_for_reminder: '',
  }),

  getters: {
    /**
     * Получить значение из store.
     *
     * @param {string} property
     * @returns {any}
     */
    get(property) {
      if (typeof this[property] === 'undefined') {
        return null;
      }
      return this[property];
    },
  },

  actions: {
    /**
     * Установить новое значение св-ва в store.
     *
     * @param {string} property
     * @param {any} value
     * @returns {void}
     */
    set(property, value) {
      if (typeof this[property] !== 'undefined') {
        this[property] = value;
      }
    }
  }
});
