import useScopedStyleMixin from '../../useScopedStyleMixin.js';
import RadioButtonStyles from './RadioButtonStyles.js';

const RadioButton = {
  name: 'radiobutton',
  props: {
    storeFieldId: String,
    dataSource: Object,
    dataValue: String,
    options: Object
  },
  data() {
    return {
      componentClass: 'radiobutton',
    }
  },
  mixins: [useScopedStyleMixin, RadioButtonStyles],

  template: /*html*/`
    <div
      :class="componentClass + hash"
    >
      <label
        v-for="(option, value) in options"
        :class="componentClass + '__label' + hash"
      >
        <input 
          type="radio" 
          :value="value" 
          v-model="dataSource[storeFieldId]" 
        /> 
        {{ option }}
      </label>
    </div>
  `
};

export default RadioButton;