import fileFields from './fileFields.js';
import imageFields from './imageFields.js';
import kanbanModalWindow from './kanbanModalWindow.js';
import cardFields from './cardFields.js';

export default{
  props: ['card', 'settings', 'getColor'],

  components: {
    fileFields,
    imageFields,
    cardFields,
    [globalThis.VContextmenu.Contextmenu.name]: globalThis.VContextmenu.Contextmenu,
    [globalThis.VContextmenu.ContextmenuItem.name]: globalThis.VContextmenu.ContextmenuItem,
    [globalThis.VContextmenu.ContextmenuGroup.name]: globalThis.VContextmenu.ContextmenuGroup,
    [kanbanModalWindow.name]: kanbanModalWindow,
  },

  directives: {
    contextmenu: globalThis.VContextmenu.directive,
  },

  data () {
      return {
          href: (this.settings.show_link) ? 'view_line2.php?table='+this.settings.table+'&line='+this.card.id : '#',
          backgroundColor: '',
          borderColor: '',
          boxShadow: '',
          show_modal: false,
          modal_type: '',
      }
  },
  methods:{
      goToUrl (evt) {
          if(this.settings.show_link){
              return true;
          } else {
              evt.preventDefault();
              return false;
          }
      },
      openRecord(){
          window.open(this.href, "_blank");
      },
      editRecord(){
          window.open(this.href + '&edit_mode=on', "_blank");
      },
      copyRecord(){
          window.open(this.href + '&c0py_mode=on', "_blank");
      },
      async opSelRecord(type, line_id){
          let response = await ( await fetch(`report.php?op_sel=${type}&table_id=${this.settings.table}&line_id=${line_id}`)).text();

          if(response == '1'){
              this.$emit('update_data');
          }
      },
      showModal(type){
          this.show_modal = true;
          this.modal_type = type;
      },
      closeModal(){
          this.show_modal = false;
          this.modal_type = '';
      },
      mouseOver () {
          if (this.settings.whatPaint == 'with_color_all') {
              let color = this.getColor.split(')')[0]
              color = (color != '') ? `${color}, 0.05)` : 'rgb(150,150,150,0.05)'
              this.backgroundColor = color
          } else {
              this.backgroundColor = 'rgba(150,150,150,0.05)'
          }
      },
      mouseOut () {
          this.backgroundColor = 'transparent'
      },
      async aa_execute(id, type) {
          let line_id = this.card.id;
          if(type == 2){
              window.kanban_num = this.settings.num + '';
              let t_width  = 640;
              let t_height = 500;
              let left = ( screen.width - t_width - 50 ) / 2
              if (left < 0) left = 0;
              let top  = ( screen.height - t_height - 50 ) / 2;
              if (top  < 0) top  = 0;
              if (user_button_window && !user_button_window.closed) {
                  user_button_window.close();
              }

              var user_button_window = window.open(
                  'user_button.php?id=' + id + '&sel[]=' + line_id,
                  'CustomButton',
                  'menubar=0, resizable=1, scrollbars=0, status=0, toolbar=0, top='+top+', left='+left+', width='+t_width+', height='+t_height
              );
          }
          else {
              let response_obj = await fetch('report.php?button=button&button_id=' + id + '&table_id=' + this.settings.table + '&sel=' + line_id);
              let response = await response_obj.text();

              if(response == '1'){
                  this.$emit('update_data');
              }
              else if(response.indexOf('link') !== -1){
                  location.href = response.split('|||')[1];
              }
              else {
                  $.removeCookie('aa_table');
                  $('body').append(response);
              }
          }
      }

  },
  computed: {
      getModalItems(){
          return this.settings.templates[this.modal_type] || [];
      },
      getHashes(){
          return JSON.parse(this.card.rights.genhash);
      },
      getModalTitle(){
          if(this.modal_type == 'print'){
              return lang['select_print_template'];
          }
          else if(this.modal_type == 'send'){
              return lang['select_mail_template'];
          }
          else if(this.modal_type == 'sms'){
              return lang['select_sms_template'];
          }
          else if(this.modal_type == 'hash'){
              return lang['Gen_Hash'];
          }
          else {
              return '';
          }
      },
      getModalSettingsLink(){
          return ['print', 'send', 'sms'].includes(this.modal_type)
              ? `forms.php?table=${this.settings.table}&mode=${this.modal_type}`
              : '';
      }
  },

  template: /*html*/`
    <div class="main-users_carts-content-container move" :card_id="card.id">
        <a
            class="main-users_carts-content-items"
            :card_id="card.id"
            :href="href"
            :style="{ borderColor: (this.settings.whatPaint == 'with_color_all') ? getColor : '#dce2e6', boxShadow: boxShadow }"
            target="_blank"
            @click="goToUrl"
            @mouseover="mouseOver"
            @mouseleave="mouseOut"
            v-contextmenu:contextmenu
        >
            <div style="width:100%;">
                <div class="main-users_carts-content-items--title" v-html="card.title.value"></div>
                <cardFields
                    :fields="card.other_fields"
                    :table="settings.table"
                    :cardId="card.id"
                />
            </div>
        </a>

        <v-contextmenu ref="contextmenu">
            <v-contextmenu-group>
                <v-contextmenu-item @click="openRecord">
                    <span class="fields__context-menu--new-tab"></span>
                    <span>${lang.Open_new_tab}</span>
                </v-contextmenu-item>
                <v-contextmenu-item v-if="!!card.rights.can_edit && !!card.rights.can_bed" @click="editRecord">
                    <span class="fields__context-menu--edit"></span>
                    <span>${lang.Edit}</span>
                </v-contextmenu-item>
                <v-contextmenu-item v-if="!!card.rights.can_copy && !(!!card.rights.archive) && !(!!card.rights.deleted)" @click="copyRecord">
                    <span class="fields__context-menu--copy"></span>
                    <span>${lang.Copy}</span>
                </v-contextmenu-item>
                <v-contextmenu-item v-if="!!card.rights.can_arc && !(!!card.rights.archive)" @click="opSelRecord('archive', card.id)">
                    <span class="fields__context-menu--archive"></span>
                    <span>${lang.Arhiving}</span>
                </v-contextmenu-item>
                <v-contextmenu-item v-if="(!!card.rights.deleted && !!card.rights.can_del) || (!!card.rights.archive && !!card.rights.can_arc)"  @click="opSelRecord('restore', card.id)">
                    <span class="fields__context-menu--restore"></span>
                    <span>${lang.Restore}</span>
                </v-contextmenu-item>
                <v-contextmenu-item v-if="!!card.rights.can_del" class="fieldContextMenuElementBorderDown" @click="opSelRecord('delete', card.id)">
                    <span class="fields__context-menu--delete"></span>
                    <span>${lang.Delete}</span>
                </v-contextmenu-item>
                <v-contextmenu-item v-if="!!card.rights.can_print && (settings.templates?.print?.length || 0) > 0" @click="showModal('print')">
                    <span class="fields__context-menu--print"></span>
                    <span>${lang.Print}</span>
                </v-contextmenu-item>
                <v-contextmenu-item v-if="!!card.rights.can_send && (settings?.templates?.send?.length || 0) > 0" @click="showModal('send')">
                    <span class="fields__context-menu--email"></span>
                    <span>${lang.Send_emails}</span>
                </v-contextmenu-item>
                <v-contextmenu-item v-if="card.rights.genhash !== null && card.rights.genhash !== 'null' && card.rights.genhash !== 'NULL'" @click="showModal('hash')">
                    <span class="fields__context-menu--gen-hash"></span>
                    <span>${lang.Gen_Hash}</span>
                </v-contextmenu-item>
                <v-contextmenu-item v-if="!!card.rights.can_sms && (settings.templates?.sms?.length || 0) > 0" @click="showModal('sms')">
                    <span class="fields__context-menu--sms"></span>
                    <span>${lang.SMS}</span>
                </v-contextmenu-item>
            </v-contextmenu-group>

            <v-contextmenu-group v-if="Object.keys(card.buttons).length > 0 && !!card.rights.can_bed" class="button_list">
                <v-contextmenu-item class="fieldContextMenuElementBorderDown">
                    <span class="fields__context-menu--buttons"></span>
                    <span>${lang.Buttons}</span>
                </v-contextmenu-item>
                <v-contextmenu-item v-for="button in card.buttons" :key="button.id" @click="aa_execute(button.id, button.type)">
                    {{button.name}}
                </v-contextmenu-item>
            </v-contextmenu-group>
        </v-contextmenu>

        <modal-window
            :show="show_modal"
            :title="getModalTitle"
            :settings="getModalSettingsLink"
            @close_dialog="closeModal"
        >
            <kanban-modal-window
                :type="modal_type"
                :items="getModalItems"
                :table_id="settings.table"
                :card_id="card.id"
                :hashes="getHashes"
                @close_dialog="closeModal"
            />
        </modal-window>
    </div>
  `
}
