/** Модальное окно  */
export default{
  name: 'modal-window',

  props: {
    show: {
      type: Boolean,
      default: false,
    },

    title: {
      type: String,
      default: '',
    },

    settings: {
      type: String,
      default: '',
    }
  },

  template: /*html*/`
    <transition name="fade">
      <div
        class="modal_window"
        v-if="show"
        @click="$emit('close_dialog')"
      >
        <div class="templates_modal_window__content" @click="(e) => e.stopPropagation()">
          <div class="templates_modal_window__title">
            <div class="templates_modal_window__title-title">
              {{ title }}
            </div>

            <div class="templates_modal_window__title-controls" v-if="settings.length > 0">
              <a :href="settings" target="_blank">
                <img src="images/settings_a.gif" />
              </a>
            </div>

            <button class="templates_modal_window__close" @click="$emit('close_dialog')">
              <img src="images/cancel_a.gif" />
            </button>
          </div>

          <hr />
          <slot />
        </div>
      </div>
    </transition>
  `
}
