/**
 * Мини-приложение Стена Стенаний
 *
 */

import useWallStore from './store.js'
import wallInputer from './Inputer.js';
import wallItem from './Item.js';
import localeEn from './locale/en.js';
import localeRu from './locale/ru.js';

const template = /*html*/`
<h1>{{$t("message.what_think")}}</h1>
<cbv-wall-inputer></cbv-wall-inputer>
<cbv-wall-item v-for="item in showItems" :key="item.id" :item="item"></cbv-wall-item>
`;

CB.styles.globed(/*css*/`
#wall_app {
    width: 72rem;
    margin: 5rem auto;
}
`);

const wallI18n = VueI18n.createI18n({
    locale: 'ru',
    fallbackLocale: 'en',
    messages: {
        en: localeEn,
        ru: localeRu,
    },
});

const WallApp = {
    template,
    setup() {
      const store = useWallStore();
      const { showItems } = Pinia.storeToRefs(store);
      store.getItems();
      return {
        showItems,
      }
    }
}

Vue.createApp(WallApp)
  .use(Pinia.createPinia())
  .use(wallI18n)
  .component('cbv-wall-inputer',wallInputer)
  .component('cbv-wall-item',wallItem)
  .mount('#wall_app')
