<?php
/**
 * revision_19580.php
 *
 * Устанние проблем многочисленного дулирования записей в таблице config
 *
 * Created by PhpStorm
 * @author artalexm
 * @date 28.03.2019
 * @time 14:29
 * @since 3.0.0
 */

global $sql_global_link;

$tName = $config['table_prefix'] . 'config';

$sql = [
    "START TRANSACTION",
    "ALTER TABLE $tName DROP INDEX IF EXISTS `PRIMARY`",
    "ALTER TABLE $tName ADD COLUMN IF NOT EXISTS `id` INT8 AUTO_INCREMENT PRIMARY KEY",
    "DELETE $tName
        FROM $tName
        LEFT OUTER JOIN (
           SELECT MAX(id) as rid, name
           FROM $tName 
           GROUP BY name
        ) as krows ON
           $tName.id = krows.rid
        WHERE
           krows.rid IS NULL",
    "ALTER TABLE $tName ADD UNIQUE IF NOT EXISTS `name` (`name`)",
    "COMMIT"
];

$result = false;
foreach ($sql as $q) {
    $result = @sql_query($q);
}
