<?php
/**
 * создаю таблицу "Wazzup справочник"
 */

use \Symfony\Component\Yaml\Yaml;

$extension_id = 'cbext.clientbase.wazzup';

/** @var \CB\Platform\ExtensionManager */
$extension_manager = \CB\Core::get(\CB\Core::EXTENSION_MANAGER);
if (!$extension_manager->isActive($extension_id)) {
    return;
}

$settings = sql_fetch_assoc(
    sql_select($config['table_prefix'] .'settings', "name='$extension_id'")
)['value'] ?? '';
$settings = Yaml::parse($settings ?? "") ?? [];

if ( // если нет настроек или уже есть таблица
    empty($settings) ||
    isset($settings['reference_table'])
) {
    return;
}

$reference_table = (new \CB\ApiLoc\ApilocGateway())->createTable([
    'table_name' => 'Wazzup справочник',
    'def_sort' => "`add_time` desc",
    'access' => [
        [
            'group_id' => 1,
            'acc' => 0,
            'vis_acc' => 0,
            'add_acc' => 0,
            'del_acc' => 0,
            'arc_acc' => 0,
            'imp_acc' => 0,
            'exp_acc' => 0,
            'bed_acc' => 0,
            'act_rec_acc' => 0,
            'arc_rec_acc' => 0,
            'del_rec_acc' => 0,
            'rule_filter' => '',
        ]
    ],
    'fields' => [
        [
            'field_name' => 'Идентификатор чата',
            'type' => 3,
            'access' => [],
        ],
        [
            'field_name' => 'Никнейм',
            'type' => 3,
            'access' => [],
        ],
        [
            'field_name' => 'Телефон',
            'type' => 3,
            'access' => [],
        ],
        [
            'field_name' => 'Тип чата',
            'value' => "instagram\r\nwhatsapp\r\ntelegram",
            'type' => 4,
            'access' => [],
        ]
    ]
]);

$arr = ['id' => $reference_table['table_id'], 'fields' => []];
foreach ($reference_table['fields'] as $field_name => $field_id) {
    switch ($field_name) {
        case 'Идентификатор чата':
            $arr['fields']['chat_id'] = [
                'field_id' => $field_id,
                'short_name' => 'chat_id',
                'field_name' => $field_name
            ];
            break;
        case 'Никнейм':
            $arr['fields']['username'] = [
                'field_id' => $field_id,
                'short_name' => 'username',
                'field_name' => $field_name
            ];
            break;
        case 'Телефон':
            $arr['fields']['phone'] = [
                'field_id' => $field_id,
                'short_name' => 'phone',
                'field_name' => $field_name
            ];
            break;
        case 'Тип чата':
            $arr['fields']['chat_type'] = [
                'field_id' => $field_id,
                'short_name' => 'chat_type',
                'field_name' => $field_name
            ];
            break;
    }
}

// заполняю массив настроек и фиксирую в бд
$settings['reference_table'] = $arr;
sql_update($config['table_prefix'] .'settings', [
    'value' => Yaml::dump($settings, 8, 2)
], "name='$extension_id'");
