<!DOCTYPE html>
<html>
<head>
    <meta http-equiv="Content-Type" content="text/html; charset=utf-8">
    <meta name="viewport"
          content="width=device-width, initial-scale=1, maximum-scale=1, minimum-scale=1, user-scalable=no, minimal-ui">
    <meta name="mobile-web-app-capable" content="yes">
    <meta name="apple-mobile-web-app-capable" content="yes">
    <meta name="apple-mobile-web-app-status-bar-style" content="black">

    <title>{$cur_title} - {$config.application}</title>

    <meta http-equiv="Content-Language" content="{$lang.short_name}">
    <meta name="robots" content="noindex, nofollow">

    <!-- Chrome, Firefox OS and Opera SearchBar color-->
    <meta name="theme-color" content="">
    <!-- Windows Phone SearchBar color -->
    <meta name="msapplication-navbutton-color" content="">
    <!-- iOS Safari SearchBar color -->
    <meta name="apple-mobile-web-app-status-bar-style" content="">

    <link rel="icon" href="images/{if $config.alt_favicon}alt_{/if}favicon.{$config.fav_ext}" type="image/x-icon">
    <link rel="stylesheet" href="themes/default/css/fonts.css?{$revision}">
    <link rel="stylesheet" href="themes/clientbase/libs/nprogress/nprogress.css?{$revision}">
    <link rel="stylesheet" href="cache/cur_scheme_{$config.css_id}_{$config.css_id_sheme}.css" type="text/css">

    {* Google Firebase Cloud Messaging *}
    {if $config.push_on == 1}
        <script src="https://www.gstatic.com/firebasejs/7.8.1/firebase-app.js"></script>
        <script src="https://www.gstatic.com/firebasejs/7.8.1/firebase-messaging.js"></script>
        <script src="https://www.gstatic.com/firebasejs/7.8.1/firebase-analytics.js"></script>
        <script src="include/push_notification/getToken.js"></script>
    {/if}
    {* END Google FCM *}

    <!-- Path to Framework7 Library CSS-->
    <link rel="stylesheet" href="mobile/ui/css/framework7.min.css?{$revision}">

    <link rel="stylesheet" type="text/css" href="mobile/ui/css/m.cb.style.css?{$revision}"/>

    <script type="text/javascript" src="lang/{$config.lang}.js?{$revision}"></script>
    <script type="text/javascript" src="explode.js?{$revision}"></script>
    <script type="text/javascript" src="themes/clientbase/js/color-format.js?{$revision}"></script>
    <script type="text/javascript" src="themes/clientbase/libs/jquery/jquery-3.2.1.min.js?{$revision}"></script>
    <script type="text/javascript" src="themes/clientbase/libs/jquery/jquery.cookie.js?{$revision}"></script>
    <script type="text/javascript" src="mobile/ui/lib/jquery.touchSwipe.min.js?{$revision}"></script>
    <script type="text/javascript" src="mobile/ui/lib/bootstrap.min.js?{$revision}"></script>
    <script type="text/javascript" src="base64.js?{$revision}"></script>
    <script src="themes/clientbase/libs/nprogress/nprogress.js?{$revision}"></script>

    <script language="JavaScript" type="text/javascript">
        var csrf = '{$csrf}';
        var lang_full = '{$config.lang}';
    </script>

    <link rel="stylesheet" type="text/css" href="mobile/ui/icons/flaticon.css?{$revision}"/>
    <style>
        .glyph-icon {
            margin-top: 5px;
        }

        [class^="flaticon-"]:before, [class*=" flaticon-"]:before, [class^="flaticon-"]:after, [class*=" flaticon-"]:after {
            font-family: Flaticon;
            font-size: 28px;
            font-style: normal;
            margin-left: 0px;
        }

        .preloader-indicator-modal .preloader {
            display: block;
            width: 32px;
            height: 32px;
        }

        .preloader-white {
            background-image: url("mobile/ui/img/loader-w32_2.gif");
        }

        .preloader-white:after {
            background-image: url("mobile/ui/img/loader-w32_2.gif");
        }

        .preloader-indicator-modal {
            background-color: #000;
        }

        .panel-individual {
            background-color: #384554;
            color: #fff;
        }

        .panel-individual .item-inner {
            border-bottom: 1px solid #475560;
        }

        .panel-individual .badge {
            color: #384554;
        }

        .panel-individual:active {
            background-color: #2F3A47 !important;
        }

        .item-input input[type=date] {
            width: 90%;
        }
        .navbar {
            background:
            {if $color_scheme.second_img_select}
                url('images/backgroundImages/{$color_scheme.second_img_select}'),
            {else if $color_scheme.img_select}
                url('images/backgroundImages/{$color_scheme.img_select}'),
            {/if}
            linear-gradient(to right,
                    {$color_scheme.color1} -5%,
                    {if $color_scheme.gradient_stat == 1}{$color_scheme.color4} 50%,{/if}
                    {$color_scheme.color1} 105%);
            background-size: inherit;
            box-shadow: 0px 4px 12px rgba(0, 0, 0, 0.5);
            border-bottom: none;
        }
        #nprogress .bar {
            background: #feda4e;
            z-index: 10000;
        }
        #nprogress .peg {
            box-shadow: none;
        }
    </style>
</head>

<body>

<script>
    const hasGradient     = '{$color_scheme.gradient_stat}';
    const mainColor       = '{$color_scheme.color1}';
    const secondColor     = '{$color_scheme.color4}';
    const new_line_status = {if $add_new_line eq 3}true{else}false{/if};

    $('body').show();
    $('.version').text(NProgress.version);
    NProgress.set(1);

    $(document).ready(function () {
        /* Устаналиваем цвет для поисковой строки браузера как основой цвет шапки конфигурации */
        const searchBarColor = (hasGradient == '1' || hasGradient == 'yes') ? secondColor : mainColor;
        const headOfPage = $('head');

        setTimeout(function() {
            headOfPage.find('meta[name="theme-color"]').attr('content', searchBarColor);
            headOfPage.find('meta[name="msapplication-navbutton-color"]').attr('content', searchBarColor);
            headOfPage.find('meta[name="apple-mobile-web-app-status-bar-style"]').attr('content', searchBarColor);
        }, 100);
    });
</script>


<!-- Status bar overlay for fullscreen mode-->
<div class="statusbar-overlay"></div>

<!-- Panels Overlay -->
<div class="panel-overlay"></div>
<!-- Right Panel with Reveal effect and Swipe Mode -->
<div class="panel panel-right panel-reveal m-cb-panel panel-individual">
    <div class="list-block" style="margin-bottom: 15px;">
        <ul style="border-bottom: 0px;">
            <li>
                <a href="m_menu.php" class="item-link item-content close-panel external panel-individual">
                    <div class="item-inner">
                        <div class="item-title m-cb-icon home">{$lang.Goto_main}</div>
                    </div>
                </a>
            </li>
            <li id="search_id" style="display:none">
                <a id="search_a_id"
                   href=""
                   class="item-link item-content close-panel search-panel-link panel-individual">
                    <div class="item-inner">
                        <div class="item-title m-cb-icon search">{$lang.Search}</div>
                    </div>
                </a>
            </li>
            <li>
                <a href="m_tips.php" class="item-link item-content close-panel tips-panel-link panel-individual">
                    <div class="item-inner">
                        <div class="item-title m-cb-icon tips">{$lang.Tips}</div>
                        <div class="item-after"><span class="badge m-cb-tips-count">{$active_tips_count}</span></div>
                    </div>
                </a>
            </li>
            {if $user.acc_messages}
            <li>
                <a href="m_messages.php?list=2"
                   class="item-link item-content close-panel messages-panel-link panel-individual">
                    <div class="item-inner">
                        <div class="item-title m-cb-icon msg">{$lang.Messages}</div>
                        <div class="item-after"><span class="badge m-cb-msg-count">{$active_mess_count}</span></div>
                    </div>
                </a>
            </li>
            {/if}
            <li>
                <a href="m_calendars.php"
                   class="item-link item-content close-panel calendars-panel-link panel-individual">
                    <div class="item-inner">
                        <div class="item-title m-cb-icon calendar">{$lang.Calendars}</div>
                        <div class="item-after">
                            <span class="badge m-cb-calendar-count">{if $window_calendar_data.allTodayEventCnt[$dayToday][$user.id]}{$window_calendar_data.allTodayEventCnt[$dayToday][$user.id]}{else}0{/if}</span>
                        </div>
                    </div>
                </a>
            </li>

            {if $mobile_app == 0}
                <li>
                    <a href="login.php?set_mobile=0"
                       class="item-link item-content close-panel external panel-individual">
                        <div class="item-inner">
                            <div class="item-title m-cb-icon full-size">{$lang['For_computer']}</div>
                        </div>
                    </a>
                </li>
            {/if}
            <li>
                <a href="login.php?logout" class="item-link item-content close-panel panel-individual">
                    <div class="item-inner" style="border-bottom: 1px solid #475560;">
                        <div class="item-title m-cb-icon exit"
                             onclick="location.href='login.php?logout'">{$lang.Exit}</div>
                    </div>
                </a>
            </li>
        </ul>
    </div>

    <div style="
    color: #B8BFC3;
    text-align: center;
    width: 100%;
    font-size: 12px;">
        {$lang.Entered_as}: <b style="color: #fff;">{$user.fio}</b>
    </div>
    <div class="list-block bottom-block">
        <div style="
        color: #B8BFC3;
        text-align: center;
        width: 100%;
        font-size: 12px;
        margin-bottom: 6px;
    ">{if $config.copyright}{if !$mobile_app}© {$app_host} /{/if} {$lang["Version"]}: {$version}{else}{$config.bottom_text|replace:'{version}':$version}{/if}</div>
    </div>
</div>

<div class="views">
    <div class="view view-main">
        {if $to_user}
            <div class="navbar">
                <div class="navbar-inner">
                    <div class="left">
                        {if $user.id}
                            {if !$is_home}
                                <div onclick="goTo();">
                                    <i class="glyph-icon flaticon-arrow395"></i>
                                </div>
                            {/if}
                        {/if}
                    </div>
                    <div class="center">
                        {if $to_user_fio}
                            <span>
                                {$to_user_fio}
                            </span>
                        {else}
                            <span>
                                {$lang.Chat}
                            </span>
                        {/if}
                    </div>
                    <div class="right">
                        {if $user.id}
                            <a href="#" data-panel="right" class="link open-panel">
                                <div class="m-cb-icon open-menu">
                                    {assign var="all_active_count" value=$active_tips_count + $active_mess_count + $window_calendar_data.allTodayEventCnt[$dayToday][$user.id]}
                                    {if $all_active_count > 0}
                                        {if $all_active_count >= 100}
                                            <span class="m-cb-header-all-count">&gt;99</span>
                                        {else}
                                            <span class="m-cb-header-all-count">{$all_active_count}</span>
                                        {/if}
                                    {/if}
                                </div>
                            </a>
                        {/if}
                    </div>
                </div>
            </div>
        {else}
            <div class="navbar">
                <div class="navbar-inner">
                    <div class="left">
                        {if $user.id}
                            {if !$is_home}
                                <div onclick="goTo();">
                                    <i class="glyph-icon flaticon-arrow395"></i>
                                </div>
                            {/if}
                        {/if}
                    </div>
                    <div class="center" style="left: 13px;">
                        <a href="m_menu.php" class="item-link item-content close-panel external" style="color: white;">
                            {if $config.logo}
                                <img src="cache/logo{$config.logo_rand}.{if $config.logo_svg}svg{else}png{/if}" class="m__logo-img">
                            {elseif $config.title}
                                <span class="m__logo-text">
                                    {$config.title}
                                </span>
                            {/if}
                        </a>
                    </div>
                    <div class="right">
                        {if $user.id}
                            <a href="#" data-panel="right" class="link open-panel" onclick="my_observer()">
                                <div class="m-cb-icon open-menu">
                                    {assign var="all_active_count" value=$active_tips_count + $active_mess_count + $window_calendar_data.allTodayEventCnt[$dayToday][$user.id]}
                                    {if $all_active_count > 0}
                                        {if $all_active_count >= 100}
                                            <span class="m-cb-header-all-count">&gt;99</span>
                                        {else}
                                            <span class="m-cb-header-all-count">{$all_active_count}</span>
                                        {/if}
                                    {/if}
                                </div>
                            </a>
                        {/if}
                    </div>
                </div>
            </div>
        {/if}
        <script>
            function my_observer() {
                var byName = $.getUrlVar('table');
                var byFilter = $.getUrlVar('filter');
                if (byName) {
                    $("#search_id").css('display', 'block');
                    $("#search_a_id").attr("href", "m_search.php?table=" + byName + "&filter=" + byFilter + "&back_url={$base64_current_url}");
                }
                if (!byName)
                    $("#search_id").css('display', 'none');
            }

            $.extend({
                getUrlVars: function () {
                    var vars = [], hash;
                    var hashes = window.location.href.slice(window.location.href.indexOf('?') + 1).split('&');
                    for (var i = 0; i < hashes.length; i++) {
                        hash = hashes[i].split('=');
                        vars.push(hash[0]);
                        vars[hash[0]] = hash[1];
                    }
                    return vars;
                },
                getUrlVar: function (name) {
                    return $.getUrlVars()[name];
                }
            });

            function goTo() {
                // Если в хистори есть другие посещённые страницы
                var urlSearchParams = new URLSearchParams(window.location.href);
                var back_url = urlSearchParams.get('back_url');
                let back_urls = {json_encode($back_urls)};
                if(back_url){
                    try {
                        back_url = back_urls[back_url];
                        if ( back_url.indexOf('|') !== -1 )
                            back_url = back_url.substr(back_url.indexOf('|'));
                        back_url = back_url.substr(back_url.lastIndexOf('/') + 1);

                        mainView.loadPage(back_url);
                    } catch(err) {
                        getBackIfNoBackUrl();
                    }
                }  else {
                    getBackIfNoBackUrl();
                }

                myApp.closeModal('.popup.modal-in');
            }

            function getBackIfNoBackUrl() {
                if (window.location.href.includes('fields.php')) {
                    var url = 'm_menu.php';
                    mainView.loadPage(url);
                } else if (window.location.href.includes('view_line2.php')) {
                    var url = 'fields.php?table=' + window.location.href.match(/=\d+/)[0].substr(1);
                    mainView.loadPage(url);
                } else {
                    if (history.length > 1) {
                        history.back();
                    }
                }
            }
        </script>
