import React from 'react';

export default ({ type, addNewRow }) => {
    let btnId = '';

    switch(type) {
        case 'table':
            btnId = 'fields__add-new--table';
        case 'fields':
            btnId = 'fields__add-new--field';
        case 'table-parts':
            btnId = 'fields__add-new--table-parts';
        case 'table-part-fields':
            btnId = 'fields__add-new--table-part-fields';
        case 'matching-block':
            btnId = 'fields__add-new--matching-block';
        case 'matching-fields':
            btnId = 'fields__add-new--matching-fields';
      }
    
    return (
        <span id={btnId}  
              title="Add tables"
              style={{ cursor: "pointer", textDecoration: "underline", textDecorationStyle: "dotted", color: "blue", margin: "15px 0 0 40px", fontSize: "108%" }}
              onClick={addNewRow} >
            {type === 'table' ? 'Добавить таблицу' : (type === 'table-parts' ? 'Добавить строку' : (type === 'matching-block' ? 'Добавить блок правил' : 'Добавить поле'))}
        </span>
    );
    {/*return (
        <button onClick={null} 
                id={btnId}  
                title="Add tables"
                className="action-btns__item action-btns__item--add-agent default-btn no_print config__add-row-btn"
                onClick={addNewRow} >
            <span>
                {type === 'table' ? 'Добавить таблицу' : (type === 'table-parts' ? 'Добавить строку' : 'Добавить поле')}
            </span>
        </button>
    );*/}
}