import React, { useEffect, useRef } from 'react';

export default ({ curValue, fieldId, field1C = null, curField1c = null, options, optionsSub = null, changeValue, allIds, editMode, editId, curBlockId = null, blockId = null, type = null }) => {
    let isNotEdit = false;
    const selectId = 'combobox_' + rusToLatin(fieldId + '');
    const fieldIdExpression = fieldId ? (fieldId[0] == 't' ? fieldId.slice(1) : fieldId) : fieldId;
    const el = useRef(null);
    const span = useRef(null);

    allIds.forEach(function (item, i, allIds) {
        if (Object.keys(item)[0] === fieldId) isNotEdit = true;
    });
    let expression1C = field1C !== null && curField1c !== null ? (field1C == curField1c ? true : false) : true;
    let expressionSub = optionsSub != null && optionsSub != void 0 ? (optionsSub.length < 1 ? false : true) : false; 
    let inpitClass = (editId && fieldIdExpression === editId && expression1C) ? (!editMode ? '' : (curBlockId !== null && blockId !== null ? (curBlockId != blockId ? '' : ' hidden' ) : ' hidden')) : '';
    let selectClass = (editId && fieldIdExpression === editId && expression1C) ? (editMode ? (curBlockId !== null && blockId !== null ? (curBlockId == blockId ? '' : ' hidden') : '') : ' hidden') : ' hidden';

    useEffect(() => {

        $(el.current).chosen();

        $(el.current).on('change', handleChange);

        return () => {
            $(el.current).off('change', handleChange);
            $(el.current).chosen('destroy');
        }
    });

    function handleChange(e) {
        changeValue(e);
    }

    function formatRegisterFields(register_name_field){
        if(register_name_field.indexOf('###') !== -1 && register_name_field.indexOf('@@@') !== -1){
            return register_name_field.replace('###', '').replace('@@@', '::');
        }

        return register_name_field;
    }

    function rusToLatin(str) {
        var ru = {
            'а': 'a', 'б': 'b', 'в': 'v', 'г': 'g', 'д': 'd',
            'е': 'e', 'ё': 'e', 'ж': 'j', 'з': 'z', 'и': 'i',
            'к': 'k', 'л': 'l', 'м': 'm', 'н': 'n', 'о': 'o',
            'п': 'p', 'р': 'r', 'с': 's', 'т': 't', 'у': 'u',
            'ф': 'f', 'х': 'h', 'ц': 'c', 'ч': 'ch', 'ш': 'sh',
            'щ': 'shch', 'ы': 'y', 'э': 'e', 'ю': 'u', 'я': 'ya'
        }, n_str = [];

        str = str.replace(/[ъь]+/g, '').replace(/й/g, 'i');

        for ( var i = 0; i < str.length; ++i ) {
           n_str.push(
                  ru[ str[i] ]
               || ru[ str[i].toLowerCase() ] == undefined && str[i]
               || ru[ str[i].toLowerCase() ].toUpperCase()
           );
        }

        return n_str.join('');
    }


    return (
        <>
            <input className={`config__row--display-value hidden`} value={curValue} disabled />
            <span className={`config__row--display-value${inpitClass}`} ref={span}>{formatRegisterFields(curValue)}</span>
            <span>
                <select id={selectId}
                    className={`form-control-250 config-1c__select${selectClass}`}
                    field_id={fieldId}
                    import='true' 
                    cur_value={curValue}
                    value={fieldId}
                    onChange={changeValue} 
                    type={type}
                    ref={el}
                    >
                    <option className='no-data' value={fieldId} key={curValue}>
                        {formatRegisterFields(curValue)}
                    </option>

                    {options != void 0 && options.map((option, index) => (
                        <option className='no-data' value={option['id']} type={option['type'] ? option['type'] : ''} key={index}>
                            {formatRegisterFields(option['name'])}
                        </option>
                    ))}
                    {expressionSub && (<optgroup label="Подтаблицы">
                        {optionsSub.map((option, index) => (
                            <option className='no-data' value={option['id']} type={option['type'] ? option['type'] : ''} key={index}>
                                {option['name']}
                            </option>))
                        }</optgroup>)
                    }
                </select>
            </span>
        </>

    );
}