const fields = {
  "type-of-barcode": {
    type: "dropdown",
    size: "medium",
    default: "qr",
    options: {
      "upc-a": "upc-a",
      "upc-e": "upc-e",
      "ean-8": "ean-8",
      "ean-13": "ean-13",
      "ean-13-pad": "ean-13-pad",
      "ean-13-nopad": "ean-13-nopad",
      "ean-128": "ean-128",
      "code-39": "code-39",
      "code-39-ascii": "code-39-ascii",
      "code-93": "code-93",
      "code-93-ascii": "code-93-ascii",
      "code-128": "code-128",
      codabar: "codabar",
      itf: "itf",
      qr: "qr",
      "qr-l": "qr-l",
      "qr-m": "qr-m",
      "qr-q": "qr-q",
      "qr-h": "qr-h",
      dmtx: "dmtx",
      "dmtx-s": "dmtx-s",
      "dmtx-r": "dmtx-r",
      "gs1-dmtx": "gs1-dmtx",
      "gs1-dmtx-s": "gs1-dmtx-s",
      "gs1-dmtx-r": "gs1-dmtx-r",
    },
  },

  format: {
    type: "dropdown",
    size: "medium",
    options: {
      png: "PNG",
      gif: "GIF",
      jpeg: "JPEG",
      svg: "SVG",
    },
  },

  "table-list": {
    "barcode-table": {
      type: "dropdown",
      size: "medium",
      optionsFrom: {
        source: "tables",
      },
      required: true,
    },
    "table-barcode-view": {
      type: "dropdown",
      size: "medium",
      optionsFrom: {
        source: "fields",
        parent: "barcode-table",
        fieldsType: "image",
      },
      required: true,
    },
    
    "table-barcode-url": {
      type: "input-text",
      size: "medium",
    },
  },

  "checkbox-groups": {
    type: "checkbox",
    optionsFrom: {
      source: "groups",
    },
  },
};

export default fields;
