//Описываем структуру формы настроек в виде многоуровневого массива
const composition = [
  {
    //Вкладка "Таблицы"
    header: "tables",

    forms: [
      {
        showOn: "apps",

        header: "prepare_tables",

        //listForm=true - форма со списком, управляет массивом настроек
        listForm: true,

        //field: поле, содержащее массив настроек
        field: "tables",

        //addButton: текст ссылки добавления нового элемента
        addButton: "add_table",

        //listFields - поля, которые будут выведены в списке
        listFields: ["name"],
        
        activity:  {
            field: "disabled",
            on: 0,
            off: 1
        },
        
        copy: true,

        alert: {
          field: "__error"
        },           


        formBlocks: [
          {
            //Общие настройки таблицы
            fields: ["name", "instant" ,"internal_object_id"],
          },

          {
            //Настройки вызова команда
               header: 'connector_command_settings',       
               fields: ['external_action'],
               custom: {
                   'integration-fields-mapping': {
                       prefix: "external_action_params_",
                       fieldsList: "params",
                       fieldsType: true,
                       app_object: "external_object_type",
                       app_object_static: "gpt-request",
                       app_action: "external_action",
                       help: "help_clientbase_gpt",
                       help_unique: true
                   }
               }                                        
          },  

          {
            header: "fields_mapping",
            custom: {
              "integration-fields-mapping": {
                app_object: "external_object_type",
                app_object_static: "gpt-request",
                app_action: "external_action",
                table: "internal_object_id",
                help: "help_clientbase_gpt",
                help_unique: true
              },
            },
          },
          {
            fields: ['status_service_field']
          },
          {
            showOn: "calc",
            fields: ["calc"]
          }
        ],
      },

      {
        hideOn: "apps",
        saveButton: false, 

        formBlocks: [
          {
            message: {
              template: "Ошибка активации модуля: обратитесь в службу технической поддержки",
              status: "alert",
            },
          },
        ],
      },
    ],
  },

  {
    //Вкладка "Информация"
    header: "information",

    forms: [
      {
        showOn: "apps",
        header: "prepare_information",
        saveButton: false,

        formBlocks: [
          {
            showOn: "__error",
            message: {
              template: "Ошибка: {{__error}}",
              status: "alert",
            }
          },
          {
            hideOn: "__error",
            fields: ["token_limit"],
          },
          {

            buttons: [
                            {
                                label: "Обновить информацию",
                                apiAction: "/api/dev/cbext/clientbase/clientbase_gpt/update_info",
                            }
                        ]
          },
        ],
      },
    ],
  },
];

export default composition;
