import Dropdown from "./Dropdown/Dropdown.js";
import DatetimeCondition from "./DatetimeCondition/DatetimeCondition.js";
import Link from "./Link/Link.js";
import RadioButton from "./RadioButton/RadioButton.js";
import Checkbox from "./Checkbox/Checkbox.js";
import Text from "./Text/Text.js";

const c = {};

c['text'] = Text;
c['input-text'] = {
  props: {
    storeFieldId: String,
    dataSource: Object,
    dataValue: String,
    required: String,
    size: String
  },

  template: /*html*/`
    <input
      type="text"
      :required="required"
      v-model="dataSource[storeFieldId]"
      :fieldsize="size"
      class="form-control"
      autocomplete="off"
    />
  `,
};

c['input-file'] = {
  props: {
    storeFieldId: String,
    dataSource: Object,
    dataValue: String,
    required: String,
    size: String
  },

  methods: {
    onFileChange(event) {
      const file = event.target.files[0];
      this.dataSource[this.storeFieldId] = file;
    },
  },

  computed: {
    isRequired() {
      //Если файл ранее был загружен (есть в данных), поле не обязательное
      return !this.dataSource[this.storeFieldId]?.name && this.required;
    }
  },

  template: /*html*/`
    <input type="file" :required="isRequired" @change="onFileChange" />
    <template v-if="dataSource[storeFieldId]?.name">
      <span class="file-field-value">{{dataSource[storeFieldId].name}}</span>
    </template>
  `,
};

c['input-password'] = {
  props: {
    storeFieldId: String,
    dataSource: Object,
    dataValue: String,
    required: String,
    size: String
  },

  template: /*html*/`
    <input type="password" :required="required" v-model="dataSource[storeFieldId]" :fieldsize="size" class="form-control" autocomplete="off"/>
  `,
};

c['link'] = Link;

c['input-textarea'] = {
  props: {
    storeFieldId: String,
    dataSource: Object,
    dataValue: String,
    required: String,
    size: String
  },

  template: /*html*/`
    <textarea
      :required="required"
      v-model="dataSource[storeFieldId]"
      :fieldsize="size"
      class="form-control"
    ></textarea>
  `
};

c['template'] = {
  components: { 'Dropdown': primevue.dropdown },
  props: {
    storeFieldId: String,
    dataSource: Object,
    dataValue: String,
    options: Object,
    required: Boolean,
    size: String,
    width: String,
    default: String
  },
  data() {
    return {
      selectedOption: 0
    };
  },
  computed: {
    textareaRef() {
      // Используем storeFieldId для создания уникального ref для textarea
      return `textarea-${this.storeFieldId}`;
    },
    isOptionsAvailable() {
      return this.options && Object.keys(this.options).length > 0;
    },
    optionsWithEmpty () {
      const arr = [];
      arr.push({ id: 0, name: ' - вставить поле - ' });
      for (const [key, value] of Object.entries(this.options || {})) {
        arr.push({ id: key, name: value });
      }
      return arr;
    }    
  },  
  methods: {
    onDropdownChange() {

      const ins_text = `{${this.options[this.selectedOption]}}`;

      if (!this.selectedOption) return;

        const ta = this.$refs[this.textareaRef];

        if (!ta) return;

        if (window.CKEDITOR?.instances?.body_form) {
            if (CKEDITOR.instances.body_form.mode != 'source') {
                CKEDITOR.instances.body_form.insertHtml(ins_text.replace(/\{+/g, '&#123;').replace(/\}+/g, '&#125;'));
            } else {
                if (document.selection) {
                    ta.focus();
                    const start = ta.selectionStart;
                    const end = ta.selectionEnd;
                    const value = ta.value;
                    const newValue = value.slice(0, start) + ins_text + value.slice(end);
                    ta.value = newValue;
                    this.dataSource[this.storeFieldId] = newValue;
                } else {
                  const currentValue = (this.dataSource[this.storeFieldId] || '').toString();
                  const newValue = currentValue.slice(0, ta.selectionStart) + ins_text + currentValue.slice(ta.selectionEnd);
                  this.dataSource[this.storeFieldId] = newValue;
                }
            }
        } else {
            if (document.selection) {
                ta.focus();
                const start = ta.selectionStart;
                const end = ta.selectionEnd;
                const value = ta.value;
                const newValue = value.slice(0, start) + ins_text + value.slice(end);
                ta.value = newValue;
                this.dataSource[this.storeFieldId] = newValue;
            } else {
              const currentValue = (this.dataSource[this.storeFieldId] || '').toString();
              const newValue = currentValue.slice(0, ta.selectionStart) + ins_text + currentValue.slice(ta.selectionEnd);
              this.dataSource[this.storeFieldId] = newValue;
            }
        }
    }
 
  },
  template: /*html*/`
  <div><textarea
    :required="required"
    v-model="dataSource[storeFieldId]"
    :fieldsize="size"
    class="form-control"
    :ref="textareaRef"
  ></textarea>
  <br/>
  <Dropdown 
    v-if="isOptionsAvailable"
    :size="size" 
    v-bind:options="optionsWithEmpty" 
    width="100%"
    v-model="selectedOption"
    optionLabel="name"
    optionValue="id"
    :filter="optionsWithEmpty.length > 7"
    filter-placeholder=""
    />
    <div class="div-btn" @click="onDropdownChange">ОК</div>
</div>
`}

c['dropdown'] = Dropdown;

c['checkbox'] = Checkbox;

c['radiobutton'] = RadioButton;

c['colorpicker'] = {
  props: {
    storeFieldId: String,
    dataSource: Object,
    dataValue: String
  },

  template: /*html*/`
    <input type="text" class="colorSelector" id="{{storeFieldId}}" :value="dataSource[storeFieldId]">
    <input type=hidden name="{{storeFieldId}}" v-model="dataSource[storeFieldId]">
  `
};

c['input-date'] = {
  props: {
    storeFieldId: String,
    dataSource: Object,
    dataValue: String,
    required: String,
    size: String
  },

  template: /*html*/`
    <input type="date" :required="required" v-model="dataSource[storeFieldId]" :fieldsize="size" class="form-control" />
  `,
};

c['input-datetime'] = {
  props: {
    storeFieldId: String,
    dataSource: Object,
    dataValue: String,
    required: String,
    size: String
  },

  template: /*html*/`
    <input type="datetime-local" :required="required" v-model="dataSource[storeFieldId]" :fieldsize="size" class="form-control"  />
  `,
};

c['datetime-condition'] = DatetimeCondition;

c['html'] = {
  props: {
    storeFieldId: String,
    dataSource: Object,
    dataValue: String,
  },

  template: /*html*/`
    <div v-html="dataSource[storeFieldId]"></div>
  `,
};

export const components = c;
