import useTranslate from "../../../../hooks/useTranslate.js";
import useKOSearchBlockStore from "./../store/index.js";


/** Компонент представления блока поиска */
export const SearchComponent = {
  emits: ['handleChange'],

  setup(props, {emit}) {
    const store = useKOSearchBlockStore();

    Vue.onMounted(() => {
      if (store.search_string != '') emit("handleChange");
    });

    return {
      store,
      getTranslate: useTranslate,
      // updateValue: _.debounce(() => {
      //   emit("handleChange", store.search_string);
      //   setTimeout(() => $('.repconview__table_table').fixedTable(), 500);
      // }, 500),
    }
  },

  template: /*html*/`
    <div style="
      text-align: right;
      display: flex;
      align-items: center;
      padding-bottom: 15px;
    ">
      <input
        v-model='store.search_string'
        @input='$emit("handleChange")'
        @keyup.enter='$emit("handleChange")'
        :placeholder='getTranslate("Search")'

        class='form-control'
        type='search'
        style='margin: 3px; min-width:calc(100% - 27px);'
      />

      <button
        :title='getTranslate("Search")'
        @click='$emit("handleChange")'

        type="button"
        class="header__user-item--search"
        style="
          margin-left: 5px;
          filter: var(--svg-filter-gray-on-white);
          max-width: 16px;
        "
      ></button>
    </div>
  `
}
