'use strict';

/** Блок карточки клиента */
export function CallNotification(options) {
  return {
    setup() {
      const store = Vuex.useStore();
      const VC = Vue.computed;
      const call_type = VC(() => store.state[options.prefix].call_type);

      return {
        close() {
          store.dispatch(`${options.prefix}/setValue`, {
            name: 'show_call_notification',
            data: false,
            useLS: true,
          });
        },

        answerCall() {
          store.dispatch(`${options.prefix}/answerCall`);
        },

        dropCall() {
          store.dispatch(`${options.prefix}/dropCall`);
        },

        title: VC(() => store.state[options.prefix].notification_title),
        time: VC(() => store.state[options.prefix].asterisk_time),
        from_number: VC(() => store.state[options.prefix].notification_info.from_number),
        from: VC(() => store.state[options.prefix].notification_info.from),
        from_name: VC(() => store.state[options.prefix].notification_info.from_name),
        from_url: VC(() => store.state[options.prefix].notification_info.from_url),
        addit_1: VC(() => store.state[options.prefix].notification_info.addit_1),
        addit_2: VC(() => store.state[options.prefix].notification_info.addit_2),
        addit_3: VC(() => store.state[options.prefix].notification_info.addit_3),

        // все для if`ов ))
        is_call: VC(() => store.state[options.prefix].is_call),
        call_type
      }
    },

    template: /*html*/`
      <div
        class="call_notification--container"
        style="position:fixed;right:50px;bottom:200px;min-width:250px;"
      >
        <div >
            <!-- заголовок уведомления -->
            <div class="call_notification--header">
              <div>
                <div class="call_notification--header-bell"></div>
                <div class="call_notification--header-title">{{ title }}</div>
              </div>
              <button class="call_notification--header-close" @click="close"></button>
            </div>

            <!-- Время, которое тикает -->
            <div
              class="event_content event_content--asterisk event_content--fix-height call_notification--text-color"
              v-if="is_call"
            >
              <div style="font-size:14px;cursor: default;">
                <span>{{ $t("Time") }}: {{ time }}</span>
              </div>
            </div>

            <!-- Поля карточки -->
            <div
              style="cursor: default;"
              class="call_notification--info"
              v-if="call_type == 'incoming' || call_type == 'outgoing'"
            >
              <div class="call_notification--info-human">
                {{ $t('Phone') }}: {{ from_number }}
              </div>
              <div class="call_notification--info-human">
                {{ from }}
                <a style="color:#E63756;font-size:16px;" :href="from_url">
                  {{ from_name || 'Добавить клиента' }}
                </a>
              </div>
              <div class="call_notification--info-human">{{ addit_1 }}</div>
              <div class="call_notification--info-human">{{ addit_2 }}</div>
              <div class="call_notification--info-human">{{ addit_3 }}</div>

              <!-- Кнопки под карточкой -->
              <div class="call_notification--card-buttons">
                <button
                  class="call_notification--card-button"
                  style="margin-right: 10px;"
                  v-if="call_type == 'incoming' && !is_call"
                  @click="answerCall"
                >{{ $t('Answer') }}</button>

                <button
                  class="call_notification--card-button"
                  @click="dropCall"
                >{{ $t('dropCall') }}</button>
              </div>
            </div>
        </div>
      </div>
    `
  }
}
