<?php

$extension_id = 'cbext.clientbase.wazzup';

/** @var \CB\Platform\ExtensionManager */
$extension_manager = \CB\Core::get(\CB\Core::EXTENSION_MANAGER);
if (!$extension_manager->isActive($extension_id)) {
    return;
}

/** @var \CB\Service\SettingsManager */
$settings_manager = \CB\Core::get(\CB\Core::SETTINGS_MANAGER);
$settings = $settings_manager->get($extension_id);

if (empty($settings)) {
    return;
}

$changed = false;
foreach (($settings['channels'] ?? []) as $channel_id => $channel) {
    foreach (($channel['additional_option'] ?? []) as $key => $value) {
        $changed = true;
        $settings['channels'][$channel_id]['additional_option'][$key]['client_name_field_id'] = (int)(
            $value['full_name'] ?? $value['client_name_field_id']
        );
        unset($settings['channels'][$channel_id]['additional_option'][$key]['full_name']);

        $settings['channels'][$channel_id]['additional_option'][$key]['responsible_manager_field_id'] = (int)(
            $value['responsible_manager'] ?? $value['responsible_manager_field_id']
        );
        unset($settings['channels'][$channel_id]['additional_option'][$key]['responsible_manager']);
    }
}

if ($changed) {
    $settings_manager->set($extension_id, $settings);
}
