const fields = {     
        
    "DK_actor": {
        "type": "input-text",
        "default": "",
        "required": true
    },

    "DK_group": {
        "type": "input-text",
        "default": "",
        "required": true
    },
    
    "DK_token": {
        "type": "input-text",
        "default": "",
        "required": true
    },

    "DK_billingPlace": {
        "type": "input-text",
        "default": "",
        "required": true
    },

    "DK_checkType_dropdown": {
        "type": "dropdown",
        "options": {
            1: "Только чек полного расчета",
            2: "Чек предоплаты и полный расчет"
        }
    }, 

    "table-automatic-link-generation": {
        "type": "checkbox",
    },

    "table-payment-summ": {
        "type": "dropdown",
        "size": "medium",
        "optionsFrom": {
            "source": "fields",
            "parent": "target-table",
            "fieldsType": "number"
        },
        "required": true
    },

    "DK_productVat": {
        "type": "dropdown",
        "options": {
            1:  "Ставка НДС 20%",
            2:  "Ставка НДС 10%",
            3:  "Ставка НДС расч. 20/120",
            4:  "Ставка НДС расч. 10/110",
            5:  "Ставка НДС 0%",
            6:  "НДС не облагается"
        }
    },

    "DK_productType": {
        "type": "dropdown",
        "options": {
            1:  "ТОВАР",
            2:  "ПОДАКЦИЗНЫЙ ТОВАР",
            3:  "РАБОТА",
            4:  "УСЛУГА",
            5:  "СТАВКА АЗАРТНОЙ ИГРЫ",
            6:  "ВЫИГРЫШ АЗАРТНОЙ ИГРЫ",
            7:  "ЛОТЕРЕЙНЫЙ БИЛЕТ",
            8:  "ВЫИГРЫШ ЛОТЕРЕИ",
            9:  "ПРЕДОСТАВЛЕНИЕ РИД",
            10:  "ПЛАТЕЖ",
            11:  "АГЕНТСКОЕ ВОЗНАГРАЖДЕНИЕ",
            12:  "СОСТАВНОЙ ПРЕДМЕТ РАСЧЕТА",
            13:  "ИНОЙ ПРЕДМЕТ РАСЧЕТА",
            14:  "ИМУЩЕСТВЕННОЕ ПРАВО",
            15:  "ВНЕРЕАЛИЗАЦИОННЫЙ ДОХОД",
            16:  "СТРАХОВЫЕ ВЗНОСЫ",
            17:  "ТОРГОВЫЙ СБОР",
            18:  "КУРОРТНЫЙ СБОР",
            19:  "ЗАЛОГ",
            20:  "СУММА РАСХОДОВ, УМЕНЬШАЮЩАЯ ДОХОД"
        }
    },

    "table-payment-taxation": {
        "type": "dropdown",
        "size": "medium",
        "options": {
            1: "osn",
            2: "usn_income",
            4: "usn_income_outcome",
            32: "patent",
            16: "esn"
        },
        "required": true
    },

    "table-payment-taxation": {
        "type": "dropdown",
        "size": "medium",
        "options": {
            1: "osn",
            2: "usn_income",
            4: "usn_income_outcome",
            32: "patent",
            16: "esn"
        },
        "required": true
    },
    
    "table-list": {
        "target-table": {
            "type": "dropdown",
            "size": "medium",
            "optionsFrom": {
                "source": "tables"
            },
            "required": true
        },
       
        "table-payment-summ": {
            "type": "dropdown",
            "size": "medium",
            "optionsFrom": {
                "source": "fields",
                "parent": "target-table",
                "fieldsType": "number"
            },
            "required": true
        },
        "table-payment-description": {
            "type": "dropdown",
            "size": "medium",
            "optionsFrom": {
               "source": "fields",
               "parent": "target-table",
               "fieldsType": "text"
            },
            "required": true
        },
        "table-paid-amount": {
            "type": "dropdown",
            "size": "medium",
            "optionsFrom": {
               "source": "fields",
               "parent": "target-table",
               "fieldsType": "number"
            },
            "required": true
        },
        "table-payment-date": {
            "type": "dropdown",
            "size": "medium",
            "optionsFrom": {
               "source": "fields",
               "parent": "target-table",
               "fieldsType": "date"
            },
            "required": true
        },
        "table-payment-status": {
            "type": "dropdown",
            "size": "medium",
            "optionsFrom": {
               "source": "fields",
               "parent": "target-table",
               "fieldsType": "list"
            },
            "required": true
        },
        "table-payment-lifetime": {
            "type": "dropdown",
            "size": "medium",
            "options": {
                0: "indefinitely",
                24: "1 day",
                72: "3 days",
                336: "14 days",
                720: "30 days",
                2160: "90 days",
            },
            "required": true
        },
        "table-payment-lifetime-date": {
            "type": "dropdown",
            "size": "medium",
            "optionsFrom": {
               "source": "fields",
               "parent": "target-table",
               "fieldsType": "date"
            },
            "required": true
        },
        "table-automatic-link-generation": {
            "type": "checkbox",
        },
        "table-data-for-generating-check-in-online-cash-desk": {
            "type": "checkbox",
        },
        
        "table-email-for-check": {
            "type": "dropdown",
            "size": "medium",
            "optionsFrom": {
                "source": "fields",
                "parent": "target-table",
                "fieldsType": "text"
            },
            "required": true
        },
        "table-subtable": {
            "type": "dropdown",
            "size": "medium",
            "optionsFrom": {
               "source": "subtables",
               "parent": "target-table",
            },
            "required": true
        },
        "table-product-number": {
            "type": "dropdown",
            "size": "medium",
            "optionsFrom": {
               "source": "fields",
               "parent": "table-subtable",
               "fieldsType": "number"
            },
            "required": true
        },
        "table-product-name": {
            "type": "dropdown",
            "size": "medium",
            "optionsFrom": {
               "source": "fields",
               "parent": "table-subtable",
            },
            "required": true
        },
        "table-product-vendor": {
            "type": "dropdown",
            "size": "medium",
            "optionsFrom": {
               "source": "fields",
               "parent": "table-subtable",
            },
            "required": true
        },
        "table-product-quantity": {
            "type": "dropdown",
            "size": "medium",
            "optionsFrom": {
               "source": "fields",
               "parent": "table-subtable",
               "fieldsType": "number"
            },
            "required": true
        },
        "table-subtable-measure": {
            "type": "dropdown",
            "size": "medium",
            "optionsFrom": {
               "source": "tables"
            },
            "required": true
        },
        "table-measure-key": {
            "type": "dropdown",
            "size": "medium",
            "optionsFrom": {
               "source": "fields",
               "parent": "table-subtable-measure",
            },
            "required": true
        },
        "table-product-measure": {
            "type": "dropdown",
            "size": "medium",
            "optionsFrom": {
               "source": "fields",
               "parent": "table-subtable",
            },
            "required": true
        },
        "table-product-price": {
            "type": "dropdown",
            "size": "medium",
            "optionsFrom": {
               "source": "fields",
               "parent": "table-subtable",
               "fieldsType": "number"
            },
            "required": true
        },
        "table-product-vat": {
            "type": "dropdown",
            "size": "medium",
            "optionsFrom": {
               "source": "fields",
               "parent": "table-subtable",
               "fieldsType": "list"
            },
            "required": true
        },
    },
    
    "DK_productUnit": {
        "type": "dropdown",
        "options": {
            0: "Шт",
            10: "Грамм",
            11: "Килограмм",
            12: "Тонна",
            20: "Сантиметр",
            21: "Дециметр",
            22: "Метр",
            30: "Квадратный сантиметр",
            31: "Квадратный дециметр",
            32: "Квадратный метр",
            40: "Миллилитр",
            41: "Литр",
            42: "Кубический метр",
            50: "Киловатт час",
            51: "Гигакалория",
            70: "Сутки (день)",
            71: "Час",
            72: "Минута",
            73: "Секунда",
            80: "Килобайт",
            81: "Мегабайт",
            82: "Гигабайт",
            83: "Терабайт",
            255: "Применяется при использовании иных единиц измерения"
        }
    },

    "example-text": {
        "type": "input-text",
        "default": "",

    },

    "example-password": {
        "type": "input-password",
        "default": ""
    },

    "example-link": {
        "type": "link"
    },

    "example-textarea": {
        "type": "input-textarea",
        "default": "",
    },    

    "example-date": {
        "type": "input-date",
        "default": "",

    },

    "example-datetime": {
        "type": "input-datetime",
        "default": "",
    },       

    "example-checkbox": {
        "type": "checkbox",

    },    

    "example-checkbox-multi": {
        "type": "checkbox",
        "options": {

            1: "option1",
            2: "option2",
            3: "option3"
        
        }
    },       
    
    "example-radiobutton": {
        "type": "radiobutton",
        "options": {

            1: "option1",
            2: "option2",
            3: "option3"

        }
    },           

    "example-dropdown": {
        "type": "dropdown",

        "options": {

            1: "option1",
            2: "option2",
            3: "option3"

        }
    }, 


    "example-dropdown-table": {
        "type": "dropdown",
        "optionsFrom": {

            "source": "tables",

        }
    }, 

    "example-dropdown-fields": {
        "type": "dropdown",
        "optionsFrom": {

            "source": "fields",
            "parent": "example-dropdown-table",

        }
    },      

    "example-dropdown-fields-type": {
        "type": "dropdown",
        "optionsFrom": {

            "source": "fields",
            "parent": "example-dropdown-table",
            "fieldsType": "number"

        }
    },       

    "example-radio-groups": {
        "type": "radiobutton",
        "optionsFrom": {

            "source": "groups",

        }
    },        


    "example-list": {

        "example-list-fname": {

            "type": "input-text"

        },

        "example-list-name": {

            "type": "input-text"

        },

        "example-list-sname": {

            "type": "input-text"

        }        

    }

}

export default fields;