export default Pinia.defineStore('useApiTabWazzupExtensionStore', {
  state: () => ({
    api_key: '',
    webhook_uri: '',
    is_active: false,
  }),

  actions: {
    authRequest() {
      fetch("https://api.wazzup24.com/v3/webhooks", {
        method: 'GET',
        redirect: 'follow',
        headers: {
          "Authorization": `Bearer ${this.api_key}`,
          "Content-Type": "application/json"
        },
      }).then(response => {
        if (response.ok) {
          this.is_active = true;
          return response.json();
        } else {
          this.is_active = false;
          this.webhook_uri = '';
        }
      }).then(result => {
        this.webhook_uri = result?.webhooksUri
          ? this.getWebhookUri(result?.webhooksUri || '')
          : this.webhook_uri;
      });
    },

    getWebhookUri(uri = '') {
      return uri == '' ? '' : uri.split(/\//)[2] || '';
    }
  }
});
