import {
  FIELD_NUMBER,
  FIELD_DATE,
  SYSTEM_FIELD_ADD_TIME
} from "../../../../constants.js";


/**
 * Сформировать текст ссылки
 * @param {string} value
 * @param {object} field_options
 *  * field_type {integer}    тип поля
 *  * without_time {boolean}  без времени
 * @returns {string}
 */
export default function(value, field_options) {
  switch (field_options.field_type) {
    case FIELD_NUMBER:
      return (Number(value)).toLocaleString('ru-RU', {
        style: 'currency',
        currency: 'RUB',
      }).slice(0, -2);

    case FIELD_DATE:
    case SYSTEM_FIELD_ADD_TIME:
      return value == '0000-00-00 00:00:00' ? '' : (
        field_options.without_time
          ? moment(value).format('DD.MM.Y')       // без времени
          : moment(value).format('DD.MM.Y hh:mm') // с временем
      );

    default:
      return value;
  }
}
