
const WALL_STORAGE_KEY = "cb_wall_storage";

export default Pinia.defineStore('useWallStore', {
  state: () => ({
    items: [],
  }),
  getters: {
    showItems(state) {
      return state.items.sort((a, b) => (a.id < b.id))
    },
  },
  actions: {
    async getItems() {
      this.items = JSON.parse(await localforage.getItem(WALL_STORAGE_KEY))
    },
    async saveItems() {
      await localforage.setItem(WALL_STORAGE_KEY, JSON.stringify(this.items))
    },
    addItem(data) {
      this.items.push(data);
      this.saveItems();
    },
    removeItem(id) {
      this.items = this.items.filter(item => (item.id!=id))
      this.saveItems();
    },
  },
})
