'use strict';

export function Input(){
    return {
        view: function(vnode){
            return vnode.attrs.icon
                ? m('div', {
                    class: vnode.attrs.class || "",
                }, [
                    m('img', {
                        src: vnode.attrs.icon.src,
                        alt: vnode.attrs.icon.alt,
                    }),
                    m('input', {
                        id: vnode.attrs.id || "",
                        type: vnode.attrs.type,
                        placeholder: vnode.attrs.placeholder,
                        onclick: vnode.attrs.onclick ? vnode.attrs.onclick : null,
                        onkeydown: vnode.attrs.onkeydown ? vnode.attrs.onkeydown : null,
                        oninput: vnode.attrs.oninput ? vnode.attrs.oninput : null,
                        onchange: vnode.attrs.onchange ? vnode.attrs.onchange : null,
                        value: vnode.attrs.value || "",
                        disabled: vnode.attrs.disabled,
                    })
                ])
                : m('input', {
                    id: vnode.attrs.id || "",
                    class: vnode.attrs.class || "",
                    type: vnode.attrs.type,
                    placeholder: vnode.attrs.placeholder,
                    onclick: vnode.attrs.onclick ? vnode.attrs.onclick : null,
                    onkeydown: vnode.attrs.onkeydown ? vnode.attrs.onkeydown : null,
                    oninput: vnode.attrs.oninput ? vnode.attrs.oninput : null,
                    onchange: vnode.attrs.onchange ? vnode.attrs.onchange : null,
                    value: vnode.attrs.value || "",
                })
        }
    }
}
