<?php
header('Content-Type: text/html; charset=utf-8');
session_start();

$api_url = 'http://demo.crm.loc/'; // Сюда подставьте адрес своей CRM
$api_auth_key = '615cdb1dd19ef65bcb7c81a97360abc0';
$api_login = 'admin';

function send_command_server($server_url, $server_command)
{
    // Пеобразуем в json
    $data_string = json_encode($server_command);

    // установка URL и других необходимых параметров
    $ch = curl_init($server_url);
    //curl_setopt($ch, CURLOPT_PROXY, '192.168.1.1:3000');
    curl_setopt($ch, CURLOPT_CUSTOMREQUEST, "POST");
    curl_setopt($ch, CURLOPT_POSTFIELDS, $data_string);
    curl_setopt($ch, CURLOPT_HEADER, false);
    curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
    curl_setopt($ch, CURLOPT_HTTPHEADER, array(
            'Content-Type: application/json',
            'Content-Length: ' . strlen($data_string)
        )
    );

    // загрузка страницы и выдача её браузеру
    $json = curl_exec($ch);

    // Переобразуем в массив
    $result = json_decode($json, true);

    // завершение сеанса и освобождение ресурсов
    curl_close($ch);

    if (count($result)) {
        return $result;
    } else {
        return $json;
    }
}

function diff_time($time_start)
{
    print_r((int)((microtime(true) - $time_start) * 1000) . "ms <br>" . PHP_EOL);
}

function auth($auth_key, $login) {
    global $api_url;
    // Команда
    $command_auth_request = array(
        "v" => "1.0",
        "login" => $login
    );

    // Отправка команды на сервер
    $result_auth_request = send_command_server($api_url . 'api/auth/request/',
        $command_auth_request);


    // Команда
    $command_auth_auth = array(
        "v" => "1.0",
        "login" => $login,
        "hash" => md5($result_auth_request["salt"] . $auth_key)
    );

    // Отправка команды на сервер
    $result_auth_auth = send_command_server($api_url . 'api/auth/auth/', $command_auth_auth);

    $access_id = $result_auth_auth["access_id"];
    $_SESSION['access_id'] = $access_id;
    return $access_id;
}

if (isset($_SESSION['access_id'])) {
    $access_id = $_SESSION['access_id'];
} else {
    $access_id = auth($api_auth_key, $api_login);
}
$sort_by = (empty($_GET['sort_by']) ? 'f1158' : $_GET['sort_by']);
$sort_type = (empty($_GET['sort_type']) ? 'up' : $_GET['sort_type']);
if ($sort_type == 'down') {
    $sql_sort_type = 'DESC';
} else {
    $sql_sort_type = 'ASC';
}
$command_data_read = array(
    "access_id" => $access_id,
    "table_id" => 91,
    "cals" => false,
    "fields" => array("row" => array()),
    "filter" => array("row" => array("status" => array("term" => "=", "value" => 0, "union" => "AND"))),
    "sort" => array("row" => array("$sort_by" => $sql_sort_type)),
    "start" => 0,
    "limit" => 100
);

// Отправка команды на сервер
$start_time = microtime(true);
$result_data_read = send_command_server($api_url . 'api/data/read/', $command_data_read);

if (isset($result_data_read)) {
    if (!isset($result_data_read['code']) || $result_data_read['code'] < 0) {
        $command_data_read['access_id'] = auth($api_auth_key, $api_login);
        $result_data_read = send_command_server($api_url. 'api/data/read/', $command_data_read);
    }
}
$cur_time = microtime(true);
?>
<!DOCTYPE html>
<html lang="ru">
<head>
    <meta charset="UTF-8"/>
    <title>Прайс-лист</title>
    <link rel="stylesheet" type="text/css" href="demo-tables.css"/>
</head>
<body>
<header class="clearfix">
    <h1>Прайс-лист <span>CSS</span></h1>
</header>
<section>
    <div class="tutorial">
        <?php
        $array = array(
            'primer1' => '1. Таблица с раздельными строками',
            'color' => '2. Цветная таблица',
            'rounded' => '3. Таблица с закругленными углами',
            'separate' => '4. Таблица с раздельными ячейками',
            'table5' => '5. Таблица-календарь',
            'blinds' => '6. Таблица-жалюзи',
            'zebra' => '7. Таблица-зебра',
            'table-menu' => '8. Таблица-меню',
            'table_col' => '9. Таблица с акцентом на первый столбец',
            'table_blur' => '10. Таблица с эффектом размытия строк при наведении',
            'table_price' => '11. Таблица-прайс',
            'table_dark' => '12. Таблица с темным фоном и с подчеркиванием текста при наведению'
        );

        foreach ($array as $key => $value) {
            ?>
            <h3><?= $value; ?></h3>
            <table class="<?= $key; ?>">
                <caption>Прайс-лист</caption>
                <?php if ($key == 'table_col') { ?>
                    <colgroup>
                        <col style="background:#C7DAF0;">
                    </colgroup>
                <?php } ?>
                <tr>
                    <th>Наименование <a href="?sort_by=f1158&sort_type=<?= ($sort_type == 'down') ? 'up' : 'down'; ?>">(sort) <?php if ($sort_by == 'f1158') { ?><img height=8 width=11 src="web/images/sort_<?= $sort_type; ?>.png"><?php } ?></a></th>
                    <th>Цена <a href="?sort_by=f1169&sort_type=<?= ($sort_type == 'down') ? 'up' : 'down'; ?>">(sort) <?php if ($sort_by == 'f1169') { ?><img height=8 width=11 src="web/images/sort_<?= $sort_type; ?>.png"><?php } ?></a></th>
                </tr>
                <?php foreach ($result_data_read['data'] as $row) { ?>
                <tr>
                    <td><?= $row['row']['f1158']; ?></td>
                    <td><?= $row['row']['f1169']; ?></td>
                </tr>
                <?php } ?>
            </table>
            <?php
        }
        ?>
</body>
</html>
